/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.Attachment;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureResponse {
    private static final Logger logger = LoggerFactory.getLogger(StoredProcedureResponse.class);
    private final RxDocumentServiceResponse response;

    StoredProcedureResponse(RxDocumentServiceResponse response) {
        this.response = response;
    }

    public String getActivityId() {
        return this.response.getResponseHeaders().get("x-ms-activity-id");
    }

    public String getSessionToken() {
        return this.response.getResponseHeaders().get("x-ms-session-token");
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getMaxResourceQuota() {
        return this.response.getResponseHeaders().get("x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return this.response.getResponseHeaders().get("x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = this.response.getResponseHeaders().get("x-ms-request-charge");
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Invalid x-ms-request-charge value {}.", (Object)value);
            return 0.0;
        }
    }

    public Map<String, String> getResponseHeaders() {
        return this.response.getResponseHeaders();
    }

    public Document getResponseAsDocument() {
        return this.response.getResource(Document.class);
    }

    public Attachment getResponseAsAttachment() {
        return this.response.getResource(Attachment.class);
    }

    public String getResponseAsString() {
        return this.response.getReponseBodyAsString();
    }

    public String getScriptLog() {
        return this.response.getResponseHeaders().get("x-ms-documentdb-script-log-results");
    }
}

