/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PartitionKey {
    private final Object[] key;
    private final String keyString;
    private PartitionKeyInternal internalPartitionKey;

    public PartitionKey(final Object key) {
        this.key = new Object[]{key};
        this.keyString = PartitionKey.toJson(Utils.getSimpleObjectMapper().valueToTree((Object)this.key));
        this.internalPartitionKey = PartitionKeyInternal.fromObjectArray((List<Object>)new ArrayList<Object>(){
            {
                this.add(key);
            }
        }, true);
    }

    public static PartitionKey FromJsonString(String jsonString) {
        JsonNode node = PartitionKey.fromJson(jsonString);
        PartitionKey key = new PartitionKey(node.get(0));
        return key;
    }

    Object[] getKey() {
        return this.key;
    }

    public String toString() {
        return this.keyString;
    }

    public PartitionKeyInternal getInternalPartitionKey() {
        return this.internalPartitionKey;
    }

    private static JsonNode fromJson(String json) {
        try {
            return Utils.getSimpleObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to parse PartitionKey JSON %s", json), e);
        }
    }

    private static String toJson(Object object) {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to convert Partitionkey to String", e);
        }
    }
}

