/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.DataType;
import com.microsoft.azure.cosmosdb.HashIndex;
import com.microsoft.azure.cosmosdb.IndexKind;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.RangeIndex;
import com.microsoft.azure.cosmosdb.SpatialIndex;
import org.apache.commons.lang3.text.WordUtils;

public abstract class Index
extends JsonSerializable {
    protected Index(IndexKind indexKind) {
        this.setKind(indexKind);
    }

    protected Index(String jsonString, IndexKind indexKind) {
        super(jsonString);
        this.setKind(indexKind);
    }

    public static RangeIndex Range(DataType dataType) {
        return new RangeIndex(dataType);
    }

    public static RangeIndex Range(DataType dataType, int precision) {
        return new RangeIndex(dataType, precision);
    }

    public static HashIndex Hash(DataType dataType) {
        return new HashIndex(dataType);
    }

    public static HashIndex Hash(DataType dataType, int precision) {
        return new HashIndex(dataType, precision);
    }

    public static SpatialIndex Spatial(DataType dataType) {
        return new SpatialIndex(dataType);
    }

    public IndexKind getKind() {
        IndexKind result = null;
        try {
            result = IndexKind.valueOf(WordUtils.capitalize((String)super.getString("kind")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Invalid index kind value %s.", (Object)super.getString("kind"));
        }
        return result;
    }

    private void setKind(IndexKind indexKind) {
        super.set("kind", indexKind.name());
    }
}

