/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.query.SortOrder;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderbyRowComparer;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByDocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByUtils;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContextBase;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

public class OrderByDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private final String FormatPlaceHolder = "{documentdb-formattableorderbyquery-filter}";
    private final String True = "true";
    private final String collectionRid;
    private final OrderbyRowComparer<T> consumeComparer;
    private Observable<T> orderByObservable;
    private RequestChargeTracker tracker;

    private OrderByDocumentQueryExecutionContext(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> klass, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, OrderbyRowComparer<T> consumeComparer, String collectionRid, UUID correlatedActivityId) {
        super(client, resourceTypeEnum, klass, query, feedOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        this.collectionRid = collectionRid;
        this.consumeComparer = consumeComparer;
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> partitionKeyRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        OrderByDocumentQueryExecutionContext<T> context = new OrderByDocumentQueryExecutionContext<T>(client, resourceTypeEnum, resourceType, expression, feedOptions, resourceLink, partitionedQueryExecutionInfo.getQueryInfo().getRewrittenQuery(), isContinuationExpected, getLazyFeedResponse, new OrderbyRowComparer(partitionedQueryExecutionInfo.getQueryInfo().getOrderBy()), collectionRid, correlatedActivityId);
        super.initialize(partitionedQueryExecutionInfo.getQueryRanges(), partitionKeyRanges, partitionedQueryExecutionInfo.getQueryInfo().getOrderBy(), partitionedQueryExecutionInfo.getQueryInfo().getOrderByExpressions(), initialPageSize);
        return Observable.just(context);
    }

    private void initialize(List<Range<String>> queryRanges, List<PartitionKeyRange> partitionKeyRanges, Collection<SortOrder> orderBy, Collection<String> orderByExpressions, int initialPageSize) {
        super.initialize(this.collectionRid, queryRanges, partitionKeyRanges, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace("{documentdb-formattableorderbyquery-filter}", "true"), this.querySpec.getParameters()));
        this.tracker = new RequestChargeTracker();
        this.orderByObservable = OrderByUtils.orderedMerge(this.resourceType, this.consumeComparer, this.tracker, this.documentProducers).map(orderByQueryResult -> (Resource)orderByQueryResult.getPayload());
    }

    @Override
    protected OrderByDocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, int initialPageSize, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc) {
        return new OrderByDocumentProducer<T>(this.consumeComparer, this.client, collectionRid, createRequestFunc, executeFunc, targetRange, collectionRid, (Func0<IDocumentClientRetryPolicy>)((Func0)() -> this.client.getRetryPolicyFactory().getRequestPolicy()), this.resourceType, this.correlatedActivityId, initialPageSize, null, this.top);
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.orderByObservable.compose(new ItemToPageTransformer(this.tracker, this.pageSize));
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        return this.drainAsync(this.feedOptions.getMaxItemCount());
    }

    private static class ItemToPageTransformer<T extends Resource>
    implements Observable.Transformer<T, FeedResponse<T>> {
        private static final int DEFAULT_PAGE_SIZE = 100;
        private final RequestChargeTracker tracker;
        private final int maxPageSize;

        public ItemToPageTransformer(RequestChargeTracker tracker, int maxPageSize) {
            this.tracker = tracker;
            this.maxPageSize = maxPageSize > 0 ? maxPageSize : 100;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        public Observable<FeedResponse<T>> call(Observable<T> source) {
            return source.window(this.maxPageSize).map(o -> o.toList()).flatMap(resultListObs -> resultListObs, 1).map(resultList -> BridgeInternal.createFeedResponse(resultList, ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()))).switchIfEmpty(Observable.defer(() -> Observable.just(BridgeInternal.createFeedResponse(Utils.immutableListOf(), ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge())))));
        }
    }
}

