/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderByRowResult;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderbyRowComparer;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByUtils;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

class OrderByDocumentProducer<T extends Resource>
extends DocumentProducer<T> {
    private final OrderbyRowComparer<T> consumeComparer;

    OrderByDocumentProducer(OrderbyRowComparer<T> consumeComparer, IDocumentQueryClient client, String collectionResourceId, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeRequestFunc, PartitionKeyRange targetRange, String collectionLink, Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc, Class<T> resourceType, UUID correlatedActivityId, int initialPageSize, String initialContinuationToken, int top) {
        super(client, collectionResourceId, createRequestFunc, executeRequestFunc, targetRange, collectionLink, createRetryPolicyFunc, resourceType, correlatedActivityId, initialPageSize, initialContinuationToken, top);
        this.consumeComparer = consumeComparer;
    }

    @Override
    protected Observable<DocumentProducer.DocumentProducerFeedResponse> produceOnSplit(Observable<DocumentProducer<T>> replacementProducers) {
        Observable res = replacementProducers.toList().single().flatMap(documentProducers -> {
            RequestChargeTracker tracker = new RequestChargeTracker();
            return OrderByUtils.orderedMerge(this.resourceType, this.consumeComparer, tracker, documentProducers).map(orderByQueryResult -> this.resultPageFrom(tracker, (OrderByRowResult<T>)orderByQueryResult));
        });
        return res;
    }

    private DocumentProducer.DocumentProducerFeedResponse resultPageFrom(RequestChargeTracker tracker, OrderByRowResult<T> row) {
        double requestCharge = tracker.getAndResetCharge();
        Map<String, String> headers = Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        FeedResponse<OrderByRowResult<T>> fr = BridgeInternal.createFeedResponse(Collections.singletonList(row), headers);
        return new DocumentProducer.DocumentProducerFeedResponse(fr, row.getSourcePartitionKeyRange());
    }

    @Override
    protected DocumentProducer<T> createChildDocumentProducerOnSplit(PartitionKeyRange targetRange, String initialContinuationToken) {
        return new OrderByDocumentProducer<T>(this.consumeComparer, this.client, this.collectionRid, (Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest>)this.createRequestFunc, this.executeRequestFuncWithRetries, targetRange, this.collectionLink, (Func0<IDocumentClientRetryPolicy>)this.createRetryPolicyFunc, this.resourceType, this.correlatedActivityId, this.pageSize, initialContinuationToken, this.top);
    }
}

