/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionExceptionRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyRangeGoneRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxPartitionKeyRangeCache;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextBase;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.Paginator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;
import rx.functions.Func2;

public class DefaultDocumentQueryExecutionContext<T extends Resource>
extends DocumentQueryExecutionContextBase<T> {
    private boolean isContinuationExpected;

    public DefaultDocumentQueryExecutionContext(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, UUID correlatedActivityId, boolean isContinuationExpected) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, false, correlatedActivityId);
        this.isContinuationExpected = isContinuationExpected;
    }

    protected PartitionKeyInternal getPartitionKeyInternal() {
        return this.feedOptions.getPartitionKey() == null ? null : this.feedOptions.getPartitionKey().getInternalPartitionKey();
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        if (this.feedOptions == null) {
            this.feedOptions = new FeedOptions();
        }
        int maxPageSize = this.feedOptions.getMaxItemCount() != null ? this.feedOptions.getMaxItemCount() : 100;
        Func2 createRequestFunc = (continuationToken, pageSize) -> this.createRequestAsync((String)continuationToken, (Integer)pageSize);
        Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc = this.executeInternalAyncFunc();
        return Paginator.getPaginatedQueryResultAsObservable(this.feedOptions, (Func2<String, Integer, RxDocumentServiceRequest>)createRequestFunc, executeFunc, this.resourceType, maxPageSize);
    }

    public Single<List<PartitionKeyRange>> getTargetPartitionKeyRanges(String resourceId, List<Range<String>> queryRanges) {
        Range<String> r = new Range<String>("", "FF", true, false);
        return this.client.getPartitionKeyRangeCache().tryGetOverlappingRangesAsync(resourceId, r, false);
    }

    protected Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeInternalAyncFunc() {
        RxCollectionCache collectionCache = this.client.getCollectionCache();
        RxPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        IDocumentClientRetryPolicy retryPolicyInstance = this.client.getRetryPolicyFactory().getRequestPolicy();
        retryPolicyInstance = new InvalidPartitionExceptionRetryPolicy(collectionCache, retryPolicyInstance, this.resourceLink);
        if (this.resourceTypeEnum.isPartitioned()) {
            retryPolicyInstance = new PartitionKeyRangeGoneRetryPolicy(collectionCache, partitionKeyRangeCache, PathsHelper.getCollectionPath(this.resourceLink), retryPolicyInstance);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = retryPolicyInstance;
        Func1 executeFunc = req -> {
            finalRetryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            return BackoffRetryUtility.executeRetry(() -> this.executeRequestAsync((RxDocumentServiceRequest)req), finalRetryPolicyInstance).toObservable();
        };
        return executeFunc;
    }

    private Single<FeedResponse<T>> executeOnceAsync(IDocumentClientRetryPolicy retryPolicyInstance, String continuationToken) {
        RxDocumentServiceRequest request = this.createRequestAsync(continuationToken, this.feedOptions.getMaxItemCount());
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if (!Strings.isNullOrEmpty(request.getHeaders().get("x-ms-documentdb-partitionkey")) || !request.getResourceType().isPartitioned()) {
            return this.executeRequestAsync(request);
        }
        request.UseGatewayMode = true;
        return this.executeRequestAsync(request);
    }

    public RxDocumentServiceRequest createRequestAsync(String continuationToken, Integer maxPageSize) {
        Map<String, String> requestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(continuationToken, maxPageSize));
        RxDocumentServiceRequest request = this.createDocumentServiceRequest(requestHeaders, this.query, this.getPartitionKeyInternal());
        if (!StringUtils.isEmpty((CharSequence)this.feedOptions.getPartitionKeyRangeIdInternal())) {
            request.routeTo(new PartitionKeyRangeIdentity(this.feedOptions.getPartitionKeyRangeIdInternal()));
        }
        return request;
    }
}

