/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.cosmosdb.internal.routing.InMemoryCollectionRoutingMap;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.ICollectionRoutingMapCache;
import com.microsoft.azure.cosmosdb.rx.internal.IRoutingMapProvider;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentClientImpl;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.AsyncCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func0;

public class RxPartitionKeyRangeCache
implements IRoutingMapProvider,
ICollectionRoutingMapCache {
    private final Logger logger = LoggerFactory.getLogger(RxPartitionKeyRangeCache.class);
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache = new AsyncCache();
    private final RxDocumentClientImpl client;
    private final RxCollectionCache collectionCache;

    public RxPartitionKeyRangeCache(RxDocumentClientImpl client, RxCollectionCache collectionCache) {
        this.client = client;
        this.collectionCache = collectionCache;
    }

    @Override
    public Single<CollectionRoutingMap> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue) {
        return this.routingMapCache.getAsync(collectionRid, previousValue, (Func0<Single<CollectionRoutingMap>>)((Func0)() -> this.getRoutingMapForCollectionAsync(collectionRid, previousValue))).onErrorResumeNext(err -> {
            this.logger.debug("tryLookupAsync on collectionRid {} encountered failure", (Object)collectionRid, err);
            DocumentClientException dce = Utils.as(err, DocumentClientException.class);
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Single.just(null);
            }
            return Single.error((Throwable)err);
        });
    }

    @Override
    public Single<List<PartitionKeyRange>> tryGetOverlappingRangesAsync(String collectionRid, Range<String> range, boolean forceRefresh) {
        Single<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionRid, null);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh && routingMap != null) {
                this.logger.debug("tryGetOverlappingRangesAsync with forceRefresh on collectionRid {}", (Object)collectionRid);
                return this.tryLookupAsync(collectionRid, (CollectionRoutingMap)routingMap);
            }
            return Single.just((Object)routingMap);
        }).map(routingMap -> {
            if (routingMap != null) {
                return new ArrayList<PartitionKeyRange>(routingMap.getOverlappingRanges(range));
            }
            this.logger.debug("Routing Map Null for collection: {} for range: {}, forceRefresh:{}", new Object[]{collectionRid, range.toString(), forceRefresh});
            return null;
        });
    }

    @Override
    public Single<PartitionKeyRange> tryGetPartitionKeyRangeByIdAsync(String collectionResourceId, String partitionKeyRangeId, boolean forceRefresh) {
        Single<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionResourceId, null);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh && routingMap != null) {
                return this.tryLookupAsync(collectionResourceId, (CollectionRoutingMap)routingMap);
            }
            return Single.just((Object)routingMap);
        }).map(routingMap -> {
            if (routingMap != null) {
                return routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId);
            }
            this.logger.debug("Routing Map Null for collection: {}, PartitionKeyRangeId: {}, forceRefresh:{}", new Object[]{collectionResourceId, partitionKeyRangeId, forceRefresh});
            return null;
        });
    }

    public Single<PartitionKeyRange> tryGetRangeByPartitionKeyRangeId(String collectionRid, String partitionKeyRangeId) {
        Single<CollectionRoutingMap> routingMapObs = this.routingMapCache.getAsync(collectionRid, null, (Func0<Single<CollectionRoutingMap>>)((Func0)() -> this.getRoutingMapForCollectionAsync(collectionRid, null)));
        return routingMapObs.map(routingMap -> routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId)).onErrorResumeNext(err -> {
            DocumentClientException dce = Utils.as(err, DocumentClientException.class);
            this.logger.debug("tryGetRangeByPartitionKeyRangeId on collectionRid {} and partitionKeyRangeId {} encountered failure", new Object[]{collectionRid, partitionKeyRangeId, err});
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Single.just(null);
            }
            return Single.error((Throwable)dce);
        });
    }

    private Single<CollectionRoutingMap> getRoutingMapForCollectionAsync(String collectionRid, CollectionRoutingMap previousRoutingMap) {
        Single<List<PartitionKeyRange>> rangesObs = this.getPartitionKeyRange(collectionRid, false);
        return rangesObs.flatMap(ranges -> {
            List rangesTuples = ranges.stream().map(range -> new ImmutablePair(range, (Object)true)).collect(Collectors.toList());
            InMemoryCollectionRoutingMap collectionRoutingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(rangesTuples, "");
            return Single.just(collectionRoutingMap);
        });
    }

    private Single<List<PartitionKeyRange>> getPartitionKeyRange(String collectionRid, boolean forceRefresh) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, collectionRid, ResourceType.PartitionKeyRange, null);
        request.setResolvedCollectionRid(collectionRid);
        Single<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return collectionObs.flatMap(coll -> {
            Observable rs = this.client.readPartitionKeyRanges(coll.getSelfLink(), null).flatMap(p -> Observable.from(p.getResults()), 1).toList();
            return rs.toSingle();
        });
    }
}

