/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.ObservableHelper;
import com.microsoft.azure.cosmosdb.rx.internal.RetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import rx.Observable;
import rx.Single;

public class RxClientCollectionCache
extends RxCollectionCache {
    private RxStoreModel storeModel;
    private final IAuthorizationTokenProvider tokenProvider;
    private final RetryPolicy retryPolicy;

    public RxClientCollectionCache(RxStoreModel storeModel, IAuthorizationTokenProvider tokenProvider, RetryPolicy retryPolicy) {
        this.storeModel = storeModel;
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
    }

    @Override
    protected Single<DocumentCollection> getByRidAsync(String collectionRid) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.retryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(PathsHelper.generatePath(ResourceType.DocumentCollection, collectionRid, false), retryPolicyInstance), retryPolicyInstance);
    }

    @Override
    protected Single<DocumentCollection> getByNameAsync(String resourceAddress) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.retryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(resourceAddress, retryPolicyInstance), retryPolicyInstance);
    }

    private Single<DocumentCollection> readCollectionAsync(String collectionLink, IDocumentClientRetryPolicy retryPolicyInstance) {
        String path = Utils.joinPath(collectionLink, null);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, path, new HashMap<String, String>());
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        String resourceName = request.getResourceFullName();
        String authorizationToken = this.tokenProvider.getUserAuthorizationToken(resourceName, request.getResourceType(), "GET", request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey);
        try {
            authorizationToken = URLEncoder.encode(authorizationToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return Single.error((Throwable)new IllegalStateException("Failed to encode authtoken.", e));
        }
        request.getHeaders().put("authorization", authorizationToken);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        Observable<RxDocumentServiceResponse> responseObs = this.storeModel.processMessage(request);
        return responseObs.map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class).getResource()).toSingle();
    }
}

