/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.rx.internal.caches.AsyncLazy;
import com.microsoft.azure.cosmosdb.rx.internal.caches.IEqualityComparer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func0;

class AsyncCache<TKey, TValue> {
    private final Logger logger = LoggerFactory.getLogger(AsyncCache.class);
    private final ConcurrentHashMap<TKey, AsyncLazy<TValue>> values = new ConcurrentHashMap();
    private final IEqualityComparer<TValue> equalityComparer;

    public AsyncCache(IEqualityComparer<TValue> equalityComparer) {
        this.equalityComparer = equalityComparer;
    }

    public AsyncCache() {
        this(new IEqualityComparer<TValue>(){

            @Override
            public boolean areEqual(TValue value1, TValue value2) {
                if (value1 == value2) {
                    return true;
                }
                if (value1 == null || value2 == null) {
                    return false;
                }
                return value1.equals(value2);
            }
        });
    }

    public void set(TKey key, TValue value) {
        this.logger.debug("set cache[{}]={}", key, value);
        this.values.put(key, new AsyncLazy<TValue>(value));
    }

    public Single<TValue> getAsync(TKey key, TValue obsoleteValue, Func0<Single<TValue>> singleValueInitFunc) {
        AsyncLazy initialLazyValue = this.values.get(key);
        if (initialLazyValue != null) {
            this.logger.debug("cache[{}] exists", key);
            return initialLazyValue.single().toObservable().flatMap(vaule -> {
                if (!this.equalityComparer.areEqual(vaule, obsoleteValue)) {
                    this.logger.debug("Returning cache[{}] as it is different from obsoleteValue", key);
                    return Observable.just((Object)vaule);
                }
                this.logger.debug("cache[{}] result value is obsolete ({}), computing new value", key, obsoleteValue);
                AsyncLazy<Func0> asyncLazy = new AsyncLazy<Func0>((Func0)singleValueInitFunc);
                AsyncLazy actualValue = this.values.merge(key, asyncLazy, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
                return actualValue.single().toObservable();
            }, err -> {
                this.logger.debug("cache[{}] resulted in error {}, computing new value", key, err);
                AsyncLazy<Func0> asyncLazy = new AsyncLazy<Func0>((Func0)singleValueInitFunc);
                AsyncLazy resultAsyncLazy = this.values.merge(key, asyncLazy, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
                return resultAsyncLazy.single().toObservable();
            }, () -> Observable.empty()).toSingle();
        }
        this.logger.debug("cache[{}] doesn't exist, computing new value", key);
        AsyncLazy<Func0<Single<TValue>>> asyncLazy = new AsyncLazy<Func0<Single<TValue>>>(singleValueInitFunc);
        AsyncLazy resultAsyncLazy = this.values.merge(key, asyncLazy, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
        return resultAsyncLazy.single();
    }

    public void remove(TKey key) {
        this.values.remove(key);
    }

    public Single<TValue> removeAsync(TKey key) {
        AsyncLazy<TValue> lazy = this.values.remove(key);
        return lazy.single();
    }

    public void clear() {
        this.values.clear();
    }

    public void refresh(TKey key, Func0<Single<TValue>> singleValueInitFunc) {
        this.logger.debug("refreshing cache[{}]", key);
        AsyncLazy initialLazyValue = this.values.get(key);
        if (initialLazyValue != null && (initialLazyValue.isSucceeded() || initialLazyValue.isFaulted())) {
            AsyncLazy<Func0<Single<TValue>>> newLazyValue = new AsyncLazy<Func0<Single<TValue>>>(singleValueInitFunc);
            this.values.merge(key, newLazyValue, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
        }
    }
}

