/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static int getValueOrDefault(Integer val, int defaultValue) {
        return val != null ? val : defaultValue;
    }

    public static void checkStateOrThrow(boolean value, String argumentName, String message) throws IllegalArgumentException {
        IllegalArgumentException t = Utils.checkStateOrReturnException(value, argumentName, message);
        if (t != null) {
            throw t;
        }
    }

    public static void checkNotNullOrThrow(Object val, String argumentName, String message) throws NullPointerException {
        NullPointerException t = Utils.checkNotNullOrReturnException(val, argumentName, message, new Object[0]);
        if (t != null) {
            throw t;
        }
    }

    public static void checkStateOrThrow(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) throws IllegalArgumentException {
        IllegalArgumentException t = Utils.checkStateOrReturnException(value, argumentName, argumentName, messageTemplateParams);
        if (t != null) {
            throw t;
        }
    }

    public static IllegalArgumentException checkStateOrReturnException(boolean value, String argumentName, String message) {
        if (value) {
            return null;
        }
        return new IllegalArgumentException(String.format("argumentName: %s, message: %s", argumentName, message));
    }

    public static IllegalArgumentException checkStateOrReturnException(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (value) {
            return null;
        }
        return new IllegalArgumentException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    private static NullPointerException checkNotNullOrReturnException(Object val, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (val != null) {
            return null;
        }
        return new NullPointerException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    public static BadRequestException checkRequestOrReturnException(boolean value, String argumentName, String message) {
        if (value) {
            return null;
        }
        return new BadRequestException(String.format("argumentName: %s, message: %s", argumentName, message));
    }

    public static BadRequestException checkRequestOrReturnException(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (value) {
            return null;
        }
        return new BadRequestException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    public static <T extends Throwable> T as(Throwable e, Class<T> klass) {
        if (e == null) {
            return null;
        }
        if (klass.isInstance(e)) {
            return (T)e;
        }
        return null;
    }

    public static <V> List<V> immutableListOf() {
        return Collections.EMPTY_LIST;
    }

    public static <V> List<V> immutableListOf(V v1) {
        ArrayList<V> list = new ArrayList<V>();
        list.add(v1);
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> immutableMapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1) {
        Map<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map = Collections.unmodifiableMap(map);
        return map;
    }
}

