/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.Attachment;
import com.microsoft.azure.cosmosdb.Conflict;
import com.microsoft.azure.cosmosdb.Database;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.Offer;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Permission;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.StoredProcedure;
import com.microsoft.azure.cosmosdb.Trigger;
import com.microsoft.azure.cosmosdb.User;
import com.microsoft.azure.cosmosdb.UserDefinedFunction;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Address;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RxDocumentServiceResponse {
    private final int statusCode;
    private final Map<String, String> headersMap;
    private final StoreResponse storeResponse;

    public RxDocumentServiceResponse(StoreResponse response) {
        String[] headerNames = response.getResponseHeaderNames();
        String[] headerValues = response.getResponseHeaderValues();
        this.headersMap = new HashMap<String, String>(headerNames.length);
        this.statusCode = response.getStatus();
        for (int i = 0; i < headerNames.length; ++i) {
            if (headerNames[i].equals("lsn")) continue;
            this.headersMap.put(headerNames[i], headerValues[i]);
        }
        this.storeResponse = response;
    }

    public static <T extends Resource> String getResourceKey(Class<T> c) {
        if (c.equals(Attachment.class)) {
            return "Attachments";
        }
        if (c.equals(Conflict.class)) {
            return "Conflicts";
        }
        if (c.equals(Database.class)) {
            return "Databases";
        }
        if (Document.class.isAssignableFrom(c)) {
            return "Documents";
        }
        if (c.equals(DocumentCollection.class)) {
            return "DocumentCollections";
        }
        if (c.equals(Offer.class)) {
            return "Offers";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        if (c.equals(Permission.class)) {
            return "Permissions";
        }
        if (c.equals(Trigger.class)) {
            return "Triggers";
        }
        if (c.equals(StoredProcedure.class)) {
            return "StoredProcedures";
        }
        if (c.equals(User.class)) {
            return "Users";
        }
        if (c.equals(UserDefinedFunction.class)) {
            return "UserDefinedFunctions";
        }
        if (c.equals(Address.class)) {
            return "Addresss";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        throw new IllegalArgumentException("c");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headersMap;
    }

    public String getReponseBodyAsString() {
        return this.storeResponse.getResponseBody();
    }

    public <T extends Resource> T getResource(Class<T> c) {
        String responseBody = this.getReponseBodyAsString();
        if (StringUtils.isEmpty((CharSequence)responseBody)) {
            return null;
        }
        try {
            return (T)((Resource)c.getConstructor(String.class).newInstance(responseBody));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class object.", e);
        }
    }

    public <T extends Resource> List<T> getQueryResponse(Class<T> c) {
        JSONArray innerArray;
        String responseBody = this.getReponseBodyAsString();
        if (responseBody == null) {
            return new ArrayList();
        }
        JSONObject jobject = new JSONObject(responseBody);
        String resourceKey = RxDocumentServiceResponse.getResourceKey(c);
        JSONArray jTokenArray = jobject.getJSONArray(resourceKey);
        while (jTokenArray != null && jTokenArray.length() == 1 && (innerArray = jTokenArray.optJSONArray(0)) != null) {
            jTokenArray = innerArray;
        }
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        if (jTokenArray != null) {
            for (int i = 0; i < jTokenArray.length(); ++i) {
                Object jToken = jTokenArray.get(i);
                String resourceJson = jToken instanceof Number || jToken instanceof Boolean ? String.format("{\"%s\": %s}", "_aggregate", jToken.toString()) : jToken.toString();
                Resource resource = null;
                try {
                    resource = (Resource)c.getConstructor(String.class).newInstance(resourceJson);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
                queryResults.add(resource);
            }
        }
        return queryResults;
    }

    public InputStream getContentStream() {
        return this.storeResponse.getResponseStream();
    }
}

