/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.observables.StringObservable;

public class RxDocumentServiceRequest {
    private String resourceId;
    private final ResourceType resourceType;
    private final String path;
    private final Map<String, String> headers;
    private volatile String continuation;
    private boolean isMedia = false;
    private final boolean isNameBased;
    private final OperationType operationType;
    private final String resourceAddress;
    private volatile boolean forceNameCacheRefresh;
    private volatile boolean forceAddressRefresh;
    private volatile long sessionLsn;
    private volatile URI endpointOverride = null;
    private final String activityId;
    private volatile RequestChargeTracker requestChargeTracker;
    private volatile String resourceFullName;
    private volatile long quorumSelectedLSN;
    private volatile long globalCommittedSelectedLSN;
    private volatile StoreResponse globalStrongWriteResponse;
    private volatile ConsistencyLevel originalRequestConsistencyLevel;
    private volatile String originalSessionToken;
    private volatile String resolvedCollectionRid;
    private volatile PartitionKeyRangeIdentity partitionKeyRangeIdentity;
    private volatile PartitionKeyRange resolvedPartitionKeyRange;
    private volatile Integer defaultReplicaIndex;
    private Observable<byte[]> contentObservable;
    private byte[] byteContent;
    public boolean UseGatewayMode;
    public boolean useWriteEndpoint;
    public boolean clearSessionTokenOnSessionReadFailure;

    public boolean isReadOnlyRequest() {
        return this.operationType == OperationType.Read || this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Head || this.operationType == OperationType.HeadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery;
    }

    private RxDocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, String path, Map<String, String> headers) {
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.path = path;
        this.sessionLsn = -1L;
        this.headers = headers != null ? headers : new HashMap();
        this.isNameBased = Utils.isNameBased(path);
        this.activityId = Utils.randomUUID().toString();
        if (!this.isNameBased) {
            this.resourceId = resourceType == ResourceType.Media ? RxDocumentServiceRequest.getAttachmentIdFromMediaId(resourceId) : resourceId;
            this.resourceAddress = resourceId;
        } else {
            this.resourceAddress = this.path;
            this.resourceId = null;
        }
    }

    private RxDocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, Observable<byte[]> contentObservable, byte[] content, String path, Map<String, String> headers) {
        this(operationType, resourceId, resourceType, path, headers);
        this.byteContent = content;
        this.contentObservable = contentObservable;
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, Observable<byte[]> contentObservable, Map<String, String> headers) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, contentObservable, null, path, headers);
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, byte[] byteContent, Map<String, String> headers) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, null, byteContent, path, headers);
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, Map<String, String> headers) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, null, null, path, headers);
    }

    public void setContentBytes(byte[] bytes) {
        this.byteContent = bytes;
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Observable<byte[]> content, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, content, headers);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, InputStream inputStream, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, (Observable<byte[]>)StringObservable.from((InputStream)inputStream), headers);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, resource.toJson().getBytes(StandardCharsets.UTF_8), headers);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, String query, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, query.getBytes(StandardCharsets.UTF_8), headers);
    }

    public static RxDocumentServiceRequest create(ResourceType resourceType, String relativePath, SqlQuerySpec querySpec, QueryCompatibilityMode queryCompatibilityMode, Map<String, String> headers) {
        String queryText;
        OperationType operation;
        switch (queryCompatibilityMode) {
            case SqlQuery: {
                if (querySpec.getParameters() != null && querySpec.getParameters().size() > 0) {
                    throw new IllegalArgumentException(String.format("Unsupported argument in query compatibility mode '{%s}'", queryCompatibilityMode.name()));
                }
                operation = OperationType.SqlQuery;
                queryText = querySpec.getQueryText();
                break;
            }
            default: {
                operation = OperationType.Query;
                queryText = querySpec.toJson();
            }
        }
        Observable body = StringObservable.encode((Observable)Observable.just((Object)queryText), (Charset)StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, (Observable<byte[]>)body, headers);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, headers);
    }

    public static RxDocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers) {
        String path = PathsHelper.generatePath(resourceType, resourceId, Utils.isFeedRequest(operation));
        return new RxDocumentServiceRequest(operation, resourceId, resourceType, null, null, path, headers);
    }

    private static String extractIdFromUri(String path) {
        String[] pathParts;
        if (path.length() == 0) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        if ((pathParts = (path = path + '=').split("/")).length % 2 == 0) {
            return pathParts[pathParts.length - 2];
        }
        return pathParts[pathParts.length - 3];
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Utils.Base64Decoder.decode(mediaId.replace('-', '/').getBytes());
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Utils.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsNameBased() {
        return this.isNameBased;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public boolean isForceNameCacheRefresh() {
        return this.forceNameCacheRefresh;
    }

    public void setForceNameCacheRefresh(boolean forceNameCacheRefresh) {
        this.forceNameCacheRefresh = forceNameCacheRefresh;
    }

    public boolean isForceAddressRefresh() {
        return this.forceAddressRefresh;
    }

    public void setForceAddressRefresh(boolean forceAddressRefresh) {
        this.forceAddressRefresh = forceAddressRefresh;
    }

    public long getSessionLsn() {
        return this.sessionLsn;
    }

    public void setSessionLsn(long sessionLsn) {
        this.sessionLsn = sessionLsn;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public RequestChargeTracker getRequestChargeTracker() {
        return this.requestChargeTracker;
    }

    public void setRequestChargeTracker(RequestChargeTracker requestChargeTracker) {
        this.requestChargeTracker = requestChargeTracker;
    }

    public String getResourceFullName() {
        if (this.isNameBased) {
            String trimmedPath = Utils.trimBeginingAndEndingSlashes(this.path);
            String[] segments = trimmedPath.split("/");
            if (segments.length % 2 == 0) {
                if (Utils.IsResourceType(segments[segments.length - 2])) {
                    this.resourceFullName = trimmedPath;
                }
            } else if (Utils.IsResourceType(segments[segments.length - 1])) {
                this.resourceFullName = trimmedPath.substring(0, trimmedPath.lastIndexOf("/"));
            }
        } else {
            this.resourceFullName = this.getResourceId().toLowerCase();
        }
        return this.resourceFullName;
    }

    public String getResolvedCollectionRid() {
        return this.resolvedCollectionRid;
    }

    public void setResolvedCollectionRid(String resolvedCollectionRid) {
        this.resolvedCollectionRid = resolvedCollectionRid;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    public void routeTo(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.setPartitionKeyRangeIdentity(partitionKeyRangeIdentity);
    }

    public void setPartitionKeyRangeIdentity(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.partitionKeyRangeIdentity = partitionKeyRangeIdentity;
        if (partitionKeyRangeIdentity != null) {
            this.headers.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeIdentity.toHeader());
        } else {
            this.headers.remove("x-ms-documentdb-partitionkeyrangeid");
        }
    }

    public PartitionKeyRange getResolvedPartitionKeyRange() {
        return this.resolvedPartitionKeyRange;
    }

    public void setResolvedPartitionKeyRange(PartitionKeyRange resolvedPartitionKeyRange) {
        this.resolvedPartitionKeyRange = resolvedPartitionKeyRange;
    }

    public long getQuorumSelectedLSN() {
        return this.quorumSelectedLSN;
    }

    public void setQuorumSelectedLSN(long quorumSelectedLSN) {
        this.quorumSelectedLSN = quorumSelectedLSN;
    }

    public ConsistencyLevel getOriginalRequestConsistencyLevel() {
        return this.originalRequestConsistencyLevel;
    }

    public void setOriginalRequestConsistencyLevel(ConsistencyLevel originalRequestConsistencyLevel) {
        this.originalRequestConsistencyLevel = originalRequestConsistencyLevel;
    }

    public StoreResponse getGlobalStrongWriteResponse() {
        return this.globalStrongWriteResponse;
    }

    public void setGlobalStrongWriteResponse(StoreResponse globalStrongWriteResponse) {
        this.globalStrongWriteResponse = globalStrongWriteResponse;
    }

    public long getGlobalCommittedSelectedLSN() {
        return this.globalCommittedSelectedLSN;
    }

    public void setGlobalCommittedSelectedLSN(long globalCommittedSelectedLSN) {
        this.globalCommittedSelectedLSN = globalCommittedSelectedLSN;
    }

    public String getOriginalSessionToken() {
        return this.originalSessionToken;
    }

    public void setOriginalSessionToken(String originalSessionToken) {
        this.originalSessionToken = originalSessionToken;
    }

    public void setDefaultReplicaIndex(Integer defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }

    public boolean isChangeFeedRequest() {
        return this.headers.containsKey("A-IM");
    }

    public boolean isWritingToMaster() {
        return this.operationType.isWriteOperation() && this.resourceType.isMasterResource();
    }

    public boolean isReadingFromMaster() {
        return this.resourceType == ResourceType.Offer || this.resourceType == ResourceType.Database || this.resourceType == ResourceType.User || this.resourceType == ResourceType.Permission || this.resourceType == ResourceType.Topology || this.resourceType == ResourceType.DatabaseAccount || this.resourceType == ResourceType.PartitionKeyRange || this.resourceType == ResourceType.DocumentCollection && (this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery);
    }

    public Observable<byte[]> getContentObservable() {
        return this.contentObservable;
    }

    public byte[] getContent() {
        return this.byteContent;
    }
}

