/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.RetryOptions;
import com.microsoft.azure.cosmosdb.internal.EndpointManager;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.ResourceThrottleRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public class ClientRetryPolicy
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ClientRetryPolicy.class);
    private static final int RetryIntervalInMS = 1000;
    private static final int MaxRetryCount = 120;
    private final IDocumentClientRetryPolicy throttlingRetry;
    private final EndpointManager globalEndpointManager;
    private final boolean enableEndpointDiscovery;
    private int failoverRetryCount;
    private boolean useWriteEndpoint;
    private int sessionTokenRetryCount;
    private boolean isReadRequest;

    public ClientRetryPolicy(EndpointManager globalEndpointManager, boolean enableEndpointDiscovery, RetryOptions retryOptions) {
        this.throttlingRetry = new ResourceThrottleRetryPolicy(retryOptions.getMaxRetryAttemptsOnThrottledRequests(), retryOptions.getMaxRetryWaitTimeInSeconds());
        this.globalEndpointManager = globalEndpointManager;
        this.failoverRetryCount = 0;
        this.enableEndpointDiscovery = enableEndpointDiscovery;
        this.sessionTokenRetryCount = 0;
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        DocumentClientException clientException = Utils.as(e, DocumentClientException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 403) && Exceptions.isSubStatusCode(clientException, 3)) {
            logger.warn("Endpoint not writable. Refresh cache and retry");
            return this.shouldRetryOnEndpointFailureAsync();
        }
        if (clientException != null && Exceptions.isStatusCode(clientException, 403) && Exceptions.isSubStatusCode(clientException, 1008) && this.isReadRequest) {
            logger.warn("Endpoint not available for reads. Refresh cache and retry");
            return this.shouldRetryOnEndpointFailureAsync();
        }
        if (clientException != null && clientException.getCause() instanceof IOException || e != null && e instanceof IOException) {
            logger.warn("Endpoint not reachable. Refresh cache and retry");
            return this.shouldRetryOnEndpointFailureAsync();
        }
        if (clientException != null && Exceptions.isStatusCode(clientException, 404) && Exceptions.isSubStatusCode(clientException, 1002)) {
            return Single.just((Object)this.shouldRetryOnSessionNotAvailable());
        }
        return this.throttlingRetry.shouldRetry(e);
    }

    private IRetryPolicy.ShouldRetryResult shouldRetryOnSessionNotAvailable() {
        ++this.sessionTokenRetryCount;
        if (!this.enableEndpointDiscovery || this.useWriteEndpoint || this.sessionTokenRetryCount > 1) {
            return IRetryPolicy.ShouldRetryResult.noRetry();
        }
        logger.warn("Read session not available. Retry using write endpoint.");
        this.useWriteEndpoint = true;
        return IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO);
    }

    private Single<IRetryPolicy.ShouldRetryResult> shouldRetryOnEndpointFailureAsync() {
        if (!this.enableEndpointDiscovery || this.failoverRetryCount > 120) {
            logger.warn("ShouldRetryOnEndpointFailureAsync() Not retrying. Retry count = {}", (Object)this.failoverRetryCount);
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.noRetry());
        }
        ++this.failoverRetryCount;
        if (this.isReadRequest) {
            this.globalEndpointManager.markEndpointUnavailable();
        }
        if (this.globalEndpointManager.isClosed()) {
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.noRetry());
        }
        this.globalEndpointManager.refreshEndpointList();
        Duration retryDelay = Duration.ofMillis(1000L);
        return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(retryDelay));
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        request.useWriteEndpoint = this.useWriteEndpoint;
        request.clearSessionTokenOnSessionReadFailure = this.sessionTokenRetryCount >= 1;
        this.isReadRequest = request.isReadOnlyRequest();
    }
}

