/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx;

import com.microsoft.azure.cosmosdb.Attachment;
import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.Conflict;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.Database;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.MediaOptions;
import com.microsoft.azure.cosmosdb.MediaResponse;
import com.microsoft.azure.cosmosdb.Offer;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Permission;
import com.microsoft.azure.cosmosdb.RequestOptions;
import com.microsoft.azure.cosmosdb.ResourceResponse;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.StoredProcedure;
import com.microsoft.azure.cosmosdb.StoredProcedureResponse;
import com.microsoft.azure.cosmosdb.Trigger;
import com.microsoft.azure.cosmosdb.User;
import com.microsoft.azure.cosmosdb.UserDefinedFunction;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentClientImpl;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import rx.Observable;

public interface AsyncDocumentClient {
    public URI getServiceEndpoint();

    public URI getWriteEndpoint();

    public URI getReadEndpoint();

    public ConnectionPolicy getConnectionPolicy();

    public Observable<ResourceResponse<Database>> createDatabase(Database var1, RequestOptions var2);

    public Observable<ResourceResponse<Database>> deleteDatabase(String var1, RequestOptions var2);

    public Observable<ResourceResponse<Database>> readDatabase(String var1, RequestOptions var2);

    public Observable<FeedResponse<Database>> readDatabases(FeedOptions var1);

    public Observable<FeedResponse<Database>> queryDatabases(String var1, FeedOptions var2);

    public Observable<FeedResponse<Database>> queryDatabases(SqlQuerySpec var1, FeedOptions var2);

    public Observable<ResourceResponse<DocumentCollection>> createCollection(String var1, DocumentCollection var2, RequestOptions var3);

    public Observable<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection var1, RequestOptions var2);

    public Observable<ResourceResponse<DocumentCollection>> deleteCollection(String var1, RequestOptions var2);

    public Observable<ResourceResponse<DocumentCollection>> readCollection(String var1, RequestOptions var2);

    public Observable<FeedResponse<DocumentCollection>> readCollections(String var1, FeedOptions var2);

    public Observable<FeedResponse<DocumentCollection>> queryCollections(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<DocumentCollection>> queryCollections(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Document>> createDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Observable<ResourceResponse<Document>> upsertDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Observable<ResourceResponse<Document>> replaceDocument(String var1, Object var2, RequestOptions var3);

    public Observable<ResourceResponse<Document>> replaceDocument(Document var1, RequestOptions var2);

    public Observable<ResourceResponse<Document>> deleteDocument(String var1, RequestOptions var2);

    public Observable<ResourceResponse<Document>> readDocument(String var1, RequestOptions var2);

    public Observable<FeedResponse<Document>> readDocuments(String var1, FeedOptions var2);

    public Observable<FeedResponse<Document>> queryDocuments(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<Document>> queryDocuments(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<FeedResponse<Document>> queryDocumentChangeFeed(String var1, ChangeFeedOptions var2);

    public Observable<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String var1, FeedOptions var2);

    public Observable<ResourceResponse<StoredProcedure>> createStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Observable<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Observable<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure var1, RequestOptions var2);

    public Observable<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String var1, RequestOptions var2);

    public Observable<ResourceResponse<StoredProcedure>> readStoredProcedure(String var1, RequestOptions var2);

    public Observable<FeedResponse<StoredProcedure>> readStoredProcedures(String var1, FeedOptions var2);

    public Observable<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<StoredProcedureResponse> executeStoredProcedure(String var1, Object[] var2);

    public Observable<StoredProcedureResponse> executeStoredProcedure(String var1, RequestOptions var2, Object[] var3);

    public Observable<ResourceResponse<Trigger>> createTrigger(String var1, Trigger var2, RequestOptions var3);

    public Observable<ResourceResponse<Trigger>> upsertTrigger(String var1, Trigger var2, RequestOptions var3);

    public Observable<ResourceResponse<Trigger>> replaceTrigger(Trigger var1, RequestOptions var2);

    public Observable<ResourceResponse<Trigger>> deleteTrigger(String var1, RequestOptions var2);

    public Observable<ResourceResponse<Trigger>> readTrigger(String var1, RequestOptions var2);

    public Observable<FeedResponse<Trigger>> readTriggers(String var1, FeedOptions var2);

    public Observable<FeedResponse<Trigger>> queryTriggers(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<Trigger>> queryTriggers(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Observable<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Observable<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction var1, RequestOptions var2);

    public Observable<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String var1, RequestOptions var2);

    public Observable<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String var1, RequestOptions var2);

    public Observable<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String var1, FeedOptions var2);

    public Observable<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Attachment>> createAttachment(String var1, Attachment var2, RequestOptions var3);

    public Observable<ResourceResponse<Attachment>> upsertAttachment(String var1, Attachment var2, RequestOptions var3);

    public Observable<ResourceResponse<Attachment>> replaceAttachment(Attachment var1, RequestOptions var2);

    public Observable<ResourceResponse<Attachment>> deleteAttachment(String var1, RequestOptions var2);

    public Observable<ResourceResponse<Attachment>> readAttachment(String var1, RequestOptions var2);

    public Observable<FeedResponse<Attachment>> readAttachments(String var1, FeedOptions var2);

    public Observable<MediaResponse> readMedia(String var1);

    public Observable<MediaResponse> updateMedia(String var1, InputStream var2, MediaOptions var3);

    public Observable<FeedResponse<Attachment>> queryAttachments(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<Attachment>> queryAttachments(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Attachment>> createAttachment(String var1, InputStream var2, MediaOptions var3, RequestOptions var4);

    public Observable<ResourceResponse<Attachment>> upsertAttachment(String var1, InputStream var2, MediaOptions var3, RequestOptions var4);

    public Observable<ResourceResponse<Conflict>> readConflict(String var1, RequestOptions var2);

    public Observable<FeedResponse<Conflict>> readConflicts(String var1, FeedOptions var2);

    public Observable<FeedResponse<Conflict>> queryConflicts(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<Conflict>> queryConflicts(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Conflict>> deleteConflict(String var1, RequestOptions var2);

    public Observable<ResourceResponse<User>> createUser(String var1, User var2, RequestOptions var3);

    public Observable<ResourceResponse<User>> upsertUser(String var1, User var2, RequestOptions var3);

    public Observable<ResourceResponse<User>> replaceUser(User var1, RequestOptions var2);

    public Observable<ResourceResponse<User>> deleteUser(String var1, RequestOptions var2);

    public Observable<ResourceResponse<User>> readUser(String var1, RequestOptions var2);

    public Observable<FeedResponse<User>> readUsers(String var1, FeedOptions var2);

    public Observable<FeedResponse<User>> queryUsers(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<User>> queryUsers(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Permission>> createPermission(String var1, Permission var2, RequestOptions var3);

    public Observable<ResourceResponse<Permission>> upsertPermission(String var1, Permission var2, RequestOptions var3);

    public Observable<ResourceResponse<Permission>> replacePermission(Permission var1, RequestOptions var2);

    public Observable<ResourceResponse<Permission>> deletePermission(String var1, RequestOptions var2);

    public Observable<ResourceResponse<Permission>> readPermission(String var1, RequestOptions var2);

    public Observable<FeedResponse<Permission>> readPermissions(String var1, FeedOptions var2);

    public Observable<FeedResponse<Permission>> queryPermissions(String var1, String var2, FeedOptions var3);

    public Observable<FeedResponse<Permission>> queryPermissions(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Observable<ResourceResponse<Offer>> replaceOffer(Offer var1);

    public Observable<ResourceResponse<Offer>> readOffer(String var1);

    public Observable<FeedResponse<Offer>> readOffers(FeedOptions var1);

    public Observable<FeedResponse<Offer>> queryOffers(String var1, FeedOptions var2);

    public Observable<FeedResponse<Offer>> queryOffers(SqlQuerySpec var1, FeedOptions var2);

    public Observable<DatabaseAccount> getDatabaseAccount();

    public void close();

    public static class Builder {
        String masterKey;
        ConnectionPolicy connectionPolicy;
        ConsistencyLevel desiredConsistencyLevel;
        URI serviceEndpoint;
        int eventLoopSize = -1;

        public Builder withServiceEndpoint(String serviceEndpoint) {
            try {
                this.serviceEndpoint = new URI(serviceEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this;
        }

        public Builder withMasterKey(String masterKey) {
            this.masterKey = masterKey;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
            this.desiredConsistencyLevel = desiredConsistencyLevel;
            return this;
        }

        Builder withWorkers(int eventLoopSize) {
            this.ifThrowIllegalArgException(eventLoopSize <= 0, "invalid event loop size");
            this.eventLoopSize = eventLoopSize;
            return this;
        }

        public Builder withConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        private void ifThrowIllegalArgException(boolean value, String error) {
            if (value) {
                throw new IllegalArgumentException(error);
            }
        }

        public AsyncDocumentClient build() {
            this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot build client without service endpoint");
            this.ifThrowIllegalArgException(this.masterKey == null, "cannot build client without masterKey");
            return new RxDocumentClientImpl(this.serviceEndpoint, this.masterKey, this.connectionPolicy, this.desiredConsistencyLevel, this.eventLoopSize);
        }
    }
}

