/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PathsHelper {
    public static String generatePath(ResourceType resourceType, RxDocumentServiceRequest request, boolean isFeed) {
        if (request.getIsNameBased()) {
            return request.getPath();
        }
        return PathsHelper.generatePath(resourceType, request.getResourceId(), isFeed);
    }

    public static String generatePath(ResourceType resourceType, String ownerOrResourceId, boolean isFeed) {
        if (isFeed && (ownerOrResourceId == null || ownerOrResourceId.isEmpty()) && resourceType != ResourceType.Database && resourceType != ResourceType.Offer && resourceType != ResourceType.MasterPartition && resourceType != ResourceType.ServerPartition && resourceType != ResourceType.DatabaseAccount && resourceType != ResourceType.Topology) {
            throw new IllegalStateException("Invalid resource type");
        }
        if (isFeed && resourceType == ResourceType.Database) {
            return "dbs";
        }
        if (resourceType == ResourceType.Database) {
            return "dbs/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.DocumentCollection) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls";
        }
        if (resourceType == ResourceType.DocumentCollection) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Offer) {
            return "offers";
        }
        if (resourceType == ResourceType.Offer) {
            return "offers/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.StoredProcedure) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "sprocs";
        }
        if (resourceType == ResourceType.StoredProcedure) {
            ResourceId storedProcedureId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + storedProcedureId.getDatabaseId().toString() + "/" + "colls" + "/" + storedProcedureId.getDocumentCollectionId().toString() + "/" + "sprocs" + "/" + storedProcedureId.getStoredProcedureId().toString();
        }
        if (isFeed && resourceType == ResourceType.UserDefinedFunction) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "udfs";
        }
        if (resourceType == ResourceType.UserDefinedFunction) {
            ResourceId functionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + functionId.getDatabaseId().toString() + "/" + "colls" + "/" + functionId.getDocumentCollectionId().toString() + "/" + "udfs" + "/" + functionId.getUserDefinedFunctionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Trigger) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "triggers";
        }
        if (resourceType == ResourceType.Trigger) {
            ResourceId triggerId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + triggerId.getDatabaseId().toString() + "/" + "colls" + "/" + triggerId.getDocumentCollectionId().toString() + "/" + "triggers" + "/" + triggerId.getTriggerId().toString();
        }
        if (isFeed && resourceType == ResourceType.Conflict) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "conflicts";
        }
        if (resourceType == ResourceType.Conflict) {
            ResourceId conflictId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + conflictId.getDatabaseId().toString() + "/" + "colls" + "/" + conflictId.getDocumentCollectionId().toString() + "/" + "conflicts" + "/" + conflictId.getConflictId().toString();
        }
        if (isFeed && resourceType == ResourceType.PartitionKeyRange) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "pkranges";
        }
        if (resourceType == ResourceType.PartitionKeyRange) {
            ResourceId partitionKeyRangeId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + partitionKeyRangeId.getDatabaseId().toString() + "/" + "colls" + "/" + partitionKeyRangeId.getDocumentCollectionId().toString() + "/" + "pkranges" + "/" + partitionKeyRangeId.getPartitionKeyRangeId().toString();
        }
        if (isFeed && resourceType == ResourceType.Attachment) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + documentCollectionId.getDocumentId().toString() + "/" + "attachments";
        }
        if (resourceType == ResourceType.Attachment) {
            ResourceId attachmentId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + attachmentId.getDatabaseId().toString() + "/" + "colls" + "/" + attachmentId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + attachmentId.getDocumentId().toString() + "/" + "attachments" + "/" + attachmentId.getAttachmentId().toString();
        }
        if (isFeed && resourceType == ResourceType.User) {
            return "dbs/" + ownerOrResourceId + "/" + "users";
        }
        if (resourceType == ResourceType.User) {
            ResourceId userId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + userId.getDatabaseId().toString() + "/" + "users" + "/" + userId.getUserId().toString();
        }
        if (isFeed && resourceType == ResourceType.Permission) {
            ResourceId userId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + userId.getDatabaseId().toString() + "/" + "users" + "/" + userId.getUserId().toString() + "/" + "permissions";
        }
        if (resourceType == ResourceType.Permission) {
            ResourceId permissionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + permissionId.getDatabaseId().toString() + "/" + "users" + "/" + permissionId.getUserId().toString() + "/" + "permissions" + "/" + permissionId.getPermissionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Document) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "docs";
        }
        if (resourceType == ResourceType.Document) {
            ResourceId documentId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentId.getDatabaseId().toString() + "/" + "colls" + "/" + documentId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + documentId.getDocumentId().toString();
        }
        if (isFeed && resourceType == ResourceType.MasterPartition) {
            return "partitions";
        }
        if (resourceType == ResourceType.MasterPartition) {
            return "partitions/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.ServerPartition) {
            return "partitions";
        }
        if (resourceType == ResourceType.ServerPartition) {
            return "partitions/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.Topology) {
            return "topology";
        }
        if (resourceType == ResourceType.Topology) {
            return "topology/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.DatabaseAccount) {
            return "databaseaccount";
        }
        if (resourceType == ResourceType.DatabaseAccount) {
            return "databaseaccount/" + ownerOrResourceId;
        }
        String errorMessage = "invalid resource type";
        throw new IllegalStateException(errorMessage);
    }

    public static PathInfo parsePathSegments(String resourceUrl) {
        Pair<Boolean, ResourceId> result;
        String segmentTwo;
        String[] segments = StringUtils.strip((String)resourceUrl, (String)"/").split("/");
        if (segments == null || segments.length < 1) {
            return null;
        }
        int uriSegmentsCount = segments.length;
        String segmentOne = StringUtils.strip((String)segments[uriSegmentsCount - 1], (String)"/");
        String string = segmentTwo = uriSegmentsCount >= 2 ? StringUtils.strip((String)segments[uriSegmentsCount - 2], (String)"/") : "";
        if (!(uriSegmentsCount < 2 || "media".compareTo(segments[0]) == 0 || "offers".compareTo(segments[0]) == 0 || "partitions".compareTo(segments[0]) == 0 || "databaseaccount".compareTo(segments[0]) == 0 || ((Boolean)(result = ResourceId.tryParse(segments[1])).getLeft()).booleanValue() && ((ResourceId)result.getRight()).isDatabaseId())) {
            return PathsHelper.parseNameSegments(resourceUrl, segments);
        }
        if (uriSegmentsCount % 2 != 0 && PathsHelper.isResourceType(segmentOne)) {
            return new PathInfo(true, segmentOne, segmentOne.compareToIgnoreCase("dbs") != 0 ? segmentTwo : "", false);
        }
        if (PathsHelper.isResourceType(segmentTwo)) {
            return new PathInfo(false, segmentTwo, segmentOne, false);
        }
        return null;
    }

    public static PathInfo parseNameSegments(String resourceUrl, String[] segments) {
        if (segments == null || segments.length < 1) {
            return null;
        }
        if (segments.length % 2 == 0) {
            if (PathsHelper.isResourceType(segments[segments.length - 2])) {
                return new PathInfo(false, segments[segments.length - 2], StringEscapeUtils.unescapeJava((String)StringUtils.strip((String)resourceUrl, (String)"/")), true);
            }
        } else if (PathsHelper.isResourceType(segments[segments.length - 1])) {
            return new PathInfo(true, segments[segments.length - 1], StringEscapeUtils.unescapeJava((String)StringUtils.strip((String)resourceUrl.substring(0, StringUtils.removeEnd((String)resourceUrl, (String)"/").lastIndexOf("/")), (String)"/")), true);
        }
        return null;
    }

    private static boolean isResourceType(String resourcePathSegment) {
        if (StringUtils.isEmpty((CharSequence)resourcePathSegment)) {
            return false;
        }
        switch (resourcePathSegment.toLowerCase()) {
            case "attachments": 
            case "colls": 
            case "dbs": 
            case "permissions": 
            case "users": 
            case "docs": 
            case "sprocs": 
            case "triggers": 
            case "udfs": 
            case "conflicts": 
            case "media": 
            case "offers": 
            case "partitions": 
            case "databaseaccount": 
            case "topology": 
            case "pkranges": 
            case "schemas": {
                return true;
            }
        }
        return false;
    }

    public static String generatePathForNameBased(ResourceType resourceType, String resourceOwnerFullName, String resourceName) {
        switch (resourceType) {
            case Database: {
                return "dbs/" + resourceName;
            }
            case DocumentCollection: {
                return resourceOwnerFullName + "/" + "colls" + "/" + resourceName;
            }
            case StoredProcedure: {
                return resourceOwnerFullName + "/" + "sprocs" + "/" + resourceName;
            }
            case UserDefinedFunction: {
                return resourceOwnerFullName + "/" + "udfs" + "/" + resourceName;
            }
            case Trigger: {
                return resourceOwnerFullName + "/" + "triggers" + "/" + resourceName;
            }
            case Attachment: {
                return resourceOwnerFullName + "/" + "attachments" + "/" + resourceName;
            }
            case Conflict: {
                return resourceOwnerFullName + "/" + "conflicts" + "/" + resourceName;
            }
            case Document: {
                return resourceOwnerFullName + "/" + "docs" + "/" + resourceName;
            }
            case Offer: {
                return resourceOwnerFullName + "/" + "offers" + "/" + resourceName;
            }
            case Permission: {
                return resourceOwnerFullName + "/" + "permissions" + "/" + resourceName;
            }
            case User: {
                return resourceOwnerFullName + "/" + "users" + "/" + resourceName;
            }
            case PartitionKeyRange: {
                return resourceOwnerFullName + "/" + "pkranges" + "/" + resourceName;
            }
        }
        return null;
    }

    public static String getCollectionPath(String resourceFullName) {
        String trimmedResourceFullName;
        int index;
        if (resourceFullName != null && (index = PathsHelper.indexOfNth(trimmedResourceFullName = Utils.trimBeginingAndEndingSlashes(resourceFullName), '/', 4)) > 0) {
            return trimmedResourceFullName.substring(0, index);
        }
        return resourceFullName;
    }

    public static String getDatabasePath(String resourceFullName) {
        int index;
        if (resourceFullName != null && (index = PathsHelper.indexOfNth(resourceFullName, '/', 2)) > 0) {
            return resourceFullName.substring(0, index);
        }
        return resourceFullName;
    }

    public static boolean isNameBased(String resourceIdOrFullName) {
        return resourceIdOrFullName != null && !resourceIdOrFullName.isEmpty() && resourceIdOrFullName.length() > 4 && resourceIdOrFullName.charAt(3) == '/';
    }

    private static int indexOfNth(String str, char value, int nthOccurance) {
        int remaining = nthOccurance;
        char[] characters = str.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i] != value || --remaining != 0) continue;
            return i;
        }
        return -1;
    }

    public static ResourceType getResourcePathSegment(String resourcePathSegment) throws BadRequestException {
        if (StringUtils.isEmpty((CharSequence)resourcePathSegment)) {
            String message = String.format("String agument %s is null or empty", "resourcePathSegment");
            throw new BadRequestException(message);
        }
        switch (resourcePathSegment) {
            case "attachments": {
                return ResourceType.Attachment;
            }
            case "colls": {
                return ResourceType.DocumentCollection;
            }
            case "dbs": {
                return ResourceType.Database;
            }
            case "permissions": {
                return ResourceType.Permission;
            }
            case "users": {
                return ResourceType.User;
            }
            case "docs": {
                return ResourceType.Document;
            }
            case "sprocs": {
                return ResourceType.StoredProcedure;
            }
            case "udfs": {
                return ResourceType.UserDefinedFunction;
            }
            case "triggers": {
                return ResourceType.Trigger;
            }
            case "conflicts": {
                return ResourceType.Conflict;
            }
            case "offers": {
                return ResourceType.Offer;
            }
            case "schemas": {
                return ResourceType.Schema;
            }
        }
        String errorMessage = String.format("Resource type %s is unknown", resourcePathSegment);
        throw new BadRequestException(errorMessage);
    }

    public static String getResourcePath(ResourceType resourceType) throws BadRequestException {
        switch (resourceType) {
            case Database: {
                return "dbs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Document: {
                return "docs";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case Trigger: {
                return "triggers";
            }
            case Conflict: {
                return "conflicts";
            }
            case Attachment: {
                return "attachments";
            }
            case User: {
                return "users";
            }
            case Permission: {
                return "permissions";
            }
            case Offer: {
                return "offers";
            }
            case MasterPartition: 
            case ServerPartition: {
                return "partitions";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "/media";
            }
            case Schema: {
                return "schemas";
            }
            case DatabaseAccount: 
            case Topology: {
                return "/";
            }
        }
        String errorMessage = String.format("Resource type %s is unknown", resourceType.toString());
        throw new BadRequestException(errorMessage);
    }
}

