/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class BaseAuthorizationTokenProvider
implements AuthorizationTokenProvider {
    private final String masterKey;
    private final Mac macInstance;

    public BaseAuthorizationTokenProvider(String masterKey) {
        this.masterKey = masterKey;
        byte[] masterKeyDecodedBytes = Utils.Base64Decoder.decode(this.masterKey.getBytes());
        SecretKeySpec signingKey = new SecretKeySpec(masterKeyDecodedBytes, "HMACSHA256");
        try {
            this.macInstance = Mac.getInstance("HMACSHA256");
            this.macInstance.init(signingKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getResourceSegement(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Offer: {
                return "offers";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }

    @Override
    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers) {
        return this.generateKeyAuthorizationSignature(verb, resourceIdOrFullName, BaseAuthorizationTokenProvider.getResourceSegement(resourceType).toLowerCase(), headers);
    }

    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, String resourceSegment, Map<String, String> headers) {
        if (verb == null || verb.isEmpty()) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceSegment == null) {
            throw new IllegalArgumentException("resourceSegment");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (this.masterKey == null || this.masterKey.isEmpty()) {
            throw new IllegalArgumentException("masterKey");
        }
        if (!PathsHelper.isNameBased(resourceIdOrFullName)) {
            resourceIdOrFullName = resourceIdOrFullName.toLowerCase(Locale.ROOT);
        }
        String body = String.format("%s\n%s\n%s\n", verb.toLowerCase(), resourceSegment, resourceIdOrFullName);
        if (headers.containsKey("x-ms-date")) {
            body = body + headers.get("x-ms-date").toLowerCase();
        }
        body = body + '\n';
        if (headers.containsKey("date")) {
            body = body + headers.get("date").toLowerCase();
        }
        body = body + '\n';
        Mac mac = null;
        try {
            mac = (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = mac.doFinal(body.getBytes());
        String auth = Utils.encodeBase64String(digest);
        String authtoken = "type=master&ver=1.0&sig=" + auth;
        return authtoken;
    }

    @Override
    public String getAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            resourceToken = resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)resourceId)) {
            if (resourceTokens.size() > 0) {
                resourceToken = resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = path.split("/");
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet resourceTypesSet = new HashSet();
            Collections.addAll(resourceTypesSet, resourceTypes);
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }
}

