/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.DataType;
import com.microsoft.azure.cosmosdb.Index;
import com.microsoft.azure.cosmosdb.IndexKind;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONObject;

public final class RangeIndex
extends Index {
    public RangeIndex(DataType dataType) {
        super(IndexKind.Range);
        this.setDataType(dataType);
    }

    public RangeIndex(DataType dataType, int precision) {
        super(IndexKind.Range);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    public RangeIndex(String jsonString) {
        super(jsonString, IndexKind.Range);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public RangeIndex(JSONObject jsonObject) {
        super(jsonObject, IndexKind.Range);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonObject doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(WordUtils.capitalize((String)super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Invalid index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public void setDataType(DataType dataType) {
        super.set("dataType", dataType.name());
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public void setPrecision(int precision) {
        super.set("precision", precision);
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

