/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import java.util.Collection;
import org.json.JSONObject;

public class PartitionKeyRange
extends Resource {
    public static final String MINIMUM_INCLUSIVE_EFFECTIVE_PARTITION_KEY = "";
    public static final String MAXIMUM_EXCLUSIVE_EFFECTIVE_PARTITION_KEY = "FF";
    public static final String MASTER_PARTITION_KEY_RANGE_ID = "M";

    public PartitionKeyRange() {
    }

    public PartitionKeyRange(String jsonString) {
        super(jsonString);
    }

    public PartitionKeyRange(JSONObject jsonObject) {
        super(jsonObject);
    }

    public PartitionKeyRange(String id, String minInclusive, String maxExclusive) {
        this.setId(id);
        this.setMinInclusive(minInclusive);
        this.setMaxExclusive(maxExclusive);
    }

    public String getMinInclusive() {
        return super.getString("minInclusive");
    }

    public void setMinInclusive(String minInclusive) {
        super.set("minInclusive", minInclusive);
    }

    public String getMaxExclusive() {
        return super.getString("maxExclusive");
    }

    public void setMaxExclusive(String maxExclusive) {
        super.set("maxExclusive", maxExclusive);
    }

    public Range<String> toRange() {
        return new Range<String>(this.getMinInclusive(), this.getMaxExclusive(), true, false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionKeyRange)) {
            return false;
        }
        PartitionKeyRange otherRange = (PartitionKeyRange)obj;
        return this.getId().compareTo(otherRange.getId()) == 0 && this.getMinInclusive().compareTo(otherRange.getMinInclusive()) == 0 && this.getMaxExclusive().compareTo(otherRange.getMaxExclusive()) == 0;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 397 ^ this.getId().hashCode();
        hash = hash * 397 ^ this.getMinInclusive().hashCode();
        hash = hash * 397 ^ this.getMaxExclusive().hashCode();
        return hash;
    }

    void setParents(Collection<String> parents) {
        this.set("parents", parents);
    }

    public Collection<String> getParents() {
        return this.getCollection("parents", String.class);
    }
}

