/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.cosmosdb.SerializationFormattingPolicy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializable
implements Serializable {
    private static final int INDENT_FACTOR = 4;
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializable.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ObjectMapper om;
    transient JSONObject propertyBag = null;

    protected JsonSerializable() {
        this.propertyBag = new JSONObject();
    }

    protected JsonSerializable(String jsonString, ObjectMapper objectMapper) {
        this.propertyBag = new JSONObject(jsonString);
        this.om = objectMapper;
    }

    protected JsonSerializable(String jsonString) {
        this.propertyBag = new JSONObject(jsonString);
    }

    protected JsonSerializable(JSONObject jsonObject) {
        this.propertyBag = new JSONObject((Object)jsonObject);
    }

    protected ObjectMapper getMapper() {
        if (this.om != null) {
            return this.om;
        }
        return OBJECT_MAPPER;
    }

    private static HashMap<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = JsonSerializable.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonSerializable.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JsonSerializable.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonSerializable.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    private static Object[] convertToObjectArray(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    private static void checkForValidPOJO(Class<?> c) {
        if (c.isAnonymousClass() || c.isLocalClass()) {
            throw new IllegalArgumentException(String.format("%s can't be an anonymous or local class.", c.getName()));
        }
        if (c.isMemberClass() && !Modifier.isStatic(c.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s must be static if it's a member class.", c.getName()));
        }
    }

    protected Logger getLogger() {
        return logger;
    }

    void populatePropertyBag() {
    }

    public HashMap<String, Object> getHashMap() {
        return JsonSerializable.toMap(this.propertyBag);
    }

    public boolean has(String propertyName) {
        return this.propertyBag.has(propertyName);
    }

    public void remove(String propertyName) {
        this.propertyBag.remove(propertyName);
    }

    public <T> void set(String propertyName, T value) {
        if (value == null) {
            this.propertyBag.put(propertyName, JSONObject.NULL);
        } else if (value instanceof Collection) {
            JSONArray jsonArray = new JSONArray();
            this.internalSetCollection(propertyName, (Collection)value, jsonArray);
            this.propertyBag.put(propertyName, (Object)jsonArray);
        } else if (value.getClass().isArray()) {
            JSONArray jsonArray = new JSONArray();
            this.internalSetCollection(propertyName, Arrays.asList(JsonSerializable.convertToObjectArray(value)), jsonArray);
            this.propertyBag.put(propertyName, (Object)jsonArray);
        } else if (value instanceof JSONArray) {
            this.propertyBag.put(propertyName, value);
        } else if (value instanceof Number || value instanceof Boolean || value instanceof String || value instanceof JSONObject) {
            this.propertyBag.put(propertyName, value);
        } else if (value instanceof JsonSerializable) {
            JsonSerializable castedValue = (JsonSerializable)value;
            if (castedValue != null) {
                castedValue.populatePropertyBag();
            }
            this.propertyBag.put(propertyName, (Object)(castedValue != null ? castedValue.propertyBag : null));
        } else {
            try {
                this.propertyBag.put(propertyName, (Object)new JSONObject(this.getMapper().writeValueAsString(value)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
    }

    private <T> void internalSetCollection(String propertyName, Collection<T> collection, JSONArray targetArray) {
        for (T childValue : collection) {
            if (childValue == null) {
                targetArray.put(JSONObject.NULL);
                continue;
            }
            if (childValue instanceof Collection) {
                JSONArray childArray = new JSONArray();
                this.internalSetCollection(propertyName, (Collection)childValue, childArray);
                targetArray.put((Object)childArray);
                continue;
            }
            if (childValue instanceof Number || childValue instanceof Boolean || childValue instanceof String || childValue instanceof JSONObject) {
                targetArray.put(childValue);
                continue;
            }
            if (childValue instanceof JsonSerializable) {
                JsonSerializable castedValue = (JsonSerializable)childValue;
                castedValue.populatePropertyBag();
                targetArray.put((Object)(castedValue.propertyBag != null ? castedValue.propertyBag : new JSONObject()));
                continue;
            }
            try {
                targetArray.put((Object)new JSONObject(this.getMapper().writeValueAsString(childValue)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
    }

    public Object get(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return this.propertyBag.get(propertyName);
        }
        return null;
    }

    public String getString(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return this.propertyBag.getString(propertyName);
        }
        return null;
    }

    public Boolean getBoolean(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return this.propertyBag.getBoolean(propertyName);
        }
        return null;
    }

    public Integer getInt(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return this.propertyBag.getInt(propertyName);
        }
        return null;
    }

    public Long getLong(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return this.propertyBag.getLong(propertyName);
        }
        return null;
    }

    public Double getDouble(String propertyName) {
        if (this.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            return new Double(this.propertyBag.getDouble(propertyName));
        }
        return null;
    }

    public <T> T getObject(String propertyName, Class<T> c) {
        if (this.propertyBag.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            Object jsonObj = this.propertyBag.get(propertyName);
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                return c.cast(jsonObj);
            }
            if (Enum.class.isAssignableFrom(c)) {
                try {
                    return c.cast(c.getMethod("valueOf", String.class).invoke(null, String.class.cast(jsonObj)));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | JSONException e) {
                    throw new IllegalStateException("Failed to create enum.", e);
                }
            }
            if (JsonSerializable.class.isAssignableFrom(c)) {
                try {
                    return c.getConstructor(String.class).newInstance(jsonObj.toString());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
            }
            JsonSerializable.checkForValidPOJO(c);
            try {
                return (T)this.getMapper().readValue(jsonObj.toString(), c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get POJO.", e);
            }
        }
        return null;
    }

    public <T> Collection<T> getCollection(String propertyName, Class<T> c) {
        if (this.propertyBag.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            JSONArray jsonArray = this.propertyBag.getJSONArray(propertyName);
            ArrayList<Object> result = new ArrayList<Object>();
            boolean isBaseClass = false;
            boolean isEnumClass = false;
            boolean isJsonSerializable = false;
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                isBaseClass = true;
            } else if (Enum.class.isAssignableFrom(c)) {
                isEnumClass = true;
            } else if (JsonSerializable.class.isAssignableFrom(c)) {
                isJsonSerializable = true;
            } else {
                JsonSerializable.checkForValidPOJO(c);
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject;
                if (isBaseClass) {
                    result.add(c.cast(jsonArray.get(i)));
                    continue;
                }
                if (isEnumClass) {
                    try {
                        result.add(c.cast(c.getMethod("valueOf", String.class).invoke(null, String.class.cast(jsonArray.get(i)))));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | JSONException e) {
                        throw new IllegalStateException("Failed to create enum.", e);
                    }
                }
                if (isJsonSerializable) {
                    jsonObject = jsonArray.getJSONObject(i);
                    try {
                        result.add(c.getConstructor(String.class).newInstance(jsonObject.toString()));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to instantiate class object.", e);
                    }
                }
                jsonObject = jsonArray.getJSONObject(i);
                try {
                    result.add(this.getMapper().readValue(jsonObject.toString(), c));
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to get POJO.", e);
                }
            }
            return result;
        }
        return null;
    }

    public JSONObject getObject(String propertyName) {
        if (this.propertyBag.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            JSONObject jsonObj = this.propertyBag.getJSONObject(propertyName);
            return jsonObj;
        }
        return null;
    }

    public Collection<JSONObject> getCollection(String propertyName) {
        ArrayList<JSONObject> result = null;
        if (this.propertyBag.has(propertyName) && !this.propertyBag.isNull(propertyName)) {
            result = new ArrayList<JSONObject>();
            JSONArray jsonArray = this.propertyBag.getJSONArray(propertyName);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                result.add(jsonObject);
            }
        }
        return result;
    }

    public Object getObjectByPath(Collection<String> propertyNames) {
        JSONObject propBag = this.propertyBag;
        Object value = null;
        String propertyName = null;
        Integer matchedProperties = 0;
        Iterator<String> iterator = propertyNames.iterator();
        if (iterator.hasNext()) {
            while (propBag.has(propertyName = iterator.next())) {
                Integer n = matchedProperties;
                Integer n2 = matchedProperties = Integer.valueOf(matchedProperties + 1);
                value = propBag.get(propertyName);
                if (value.getClass() != JSONObject.class) break;
                propBag = (JSONObject)value;
                if (iterator.hasNext()) continue;
            }
            if (value != null && matchedProperties.intValue() == propertyNames.size()) {
                return value;
            }
        }
        return null;
    }

    public <T> T toObject(Class<T> c) {
        if (JsonSerializable.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("c can only be a POJO class or JSONObject");
        }
        if (JSONObject.class.isAssignableFrom(c)) {
            if (JSONObject.class != c) {
                throw new IllegalArgumentException("We support JSONObject but not its sub-classes.");
            }
            return c.cast(this.propertyBag);
        }
        JsonSerializable.checkForValidPOJO(c);
        try {
            return (T)this.getMapper().readValue(this.toJson(), c);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public String toJson() {
        return this.toJson(SerializationFormattingPolicy.None);
    }

    public String toJson(SerializationFormattingPolicy formattingPolicy) {
        this.populatePropertyBag();
        if (SerializationFormattingPolicy.Indented.equals((Object)formattingPolicy)) {
            return this.propertyBag.toString(4);
        }
        return this.propertyBag.toString();
    }

    public String toString() {
        return this.propertyBag.toString();
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        outputStream.writeObject(this.propertyBag.toString());
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException, JSONException {
        inputStream.defaultReadObject();
        this.propertyBag = new JSONObject((String)inputStream.readObject());
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

