/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FeedResponse<T extends Resource> {
    private final List<T> results;
    private final Map<String, String> header;
    private final HashMap<String, Long> usageHeaders;
    private final HashMap<String, Long> quotaHeaders;
    private final boolean useEtagAsContinuation;
    boolean nochanges;

    FeedResponse(List<T> results, Map<String, String> headers) {
        this(results, headers, false, false);
    }

    FeedResponse(List<T> results, Map<String, String> header, boolean nochanges) {
        this(results, header, true, nochanges);
    }

    private FeedResponse(List<T> results, Map<String, String> header, boolean useEtagAsContinuation, boolean nochanges) {
        this.results = results;
        this.header = header;
        this.usageHeaders = new HashMap();
        this.quotaHeaders = new HashMap();
        this.useEtagAsContinuation = useEtagAsContinuation;
        this.nochanges = nochanges;
    }

    public List<T> getResults() {
        return this.results;
    }

    public long getDatabaseQuota() {
        return this.getMaxQuotaHeader("databases");
    }

    public long getDatabaseUsage() {
        return this.getCurrentQuotaHeader("databases");
    }

    public long getCollectionQuota() {
        return this.getMaxQuotaHeader("collections");
    }

    public long getCollectionUsage() {
        return this.getCurrentQuotaHeader("collections");
    }

    public long getUserQuota() {
        return this.getMaxQuotaHeader("users");
    }

    public long getUserUsage() {
        return this.getCurrentQuotaHeader("users");
    }

    public long getPermissionQuota() {
        return this.getMaxQuotaHeader("permissions");
    }

    public long getPermissionUsage() {
        return this.getCurrentQuotaHeader("permissions");
    }

    public long getCollectionSizeQuota() {
        return this.getMaxQuotaHeader("collectionSize");
    }

    public long getCollectionSizeUsage() {
        return this.getCurrentQuotaHeader("collectionSize");
    }

    public long getStoredProceduresQuota() {
        return this.getMaxQuotaHeader("storedProcedures");
    }

    public long getStoredProceduresUsage() {
        return this.getCurrentQuotaHeader("storedProcedures");
    }

    public long getTriggersQuota() {
        return this.getMaxQuotaHeader("triggers");
    }

    public long getTriggersUsage() {
        return this.getCurrentQuotaHeader("triggers");
    }

    public long getUserDefinedFunctionsQuota() {
        return this.getMaxQuotaHeader("functions");
    }

    public long getUserDefinedFunctionsUsage() {
        return this.getCurrentQuotaHeader("functions");
    }

    public String getMaxResourceQuota() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = FeedResponse.getValueOrNull(this.header, "x-ms-request-charge");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public String getActivityId() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-activity-id");
    }

    public String getResponseContinuation() {
        String headerName = this.useEtagAsContinuation ? "etag" : "x-ms-continuation";
        return FeedResponse.getValueOrNull(this.header, headerName);
    }

    public String getSessionToken() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-session-token");
    }

    public Map<String, String> getResponseHeaders() {
        return this.header;
    }

    private long getCurrentQuotaHeader(String headerName) {
        if (this.usageHeaders.size() == 0 && !StringUtils.isEmpty((CharSequence)this.getMaxResourceQuota()) && !StringUtils.isEmpty((CharSequence)this.getCurrentResourceQuotaUsage())) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.usageHeaders.containsKey(headerName)) {
            return this.usageHeaders.get(headerName);
        }
        return 0L;
    }

    private long getMaxQuotaHeader(String headerName) {
        if (this.quotaHeaders.size() == 0 && !StringUtils.isEmpty((CharSequence)this.getMaxResourceQuota()) && !StringUtils.isEmpty((CharSequence)this.getCurrentResourceQuotaUsage())) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.quotaHeaders.containsKey(headerName)) {
            return this.quotaHeaders.get(headerName);
        }
        return 0L;
    }

    private void populateQuotaHeader(String headerMaxQuota, String headerCurrentUsage) {
        String[] headerMaxQuotaWords = headerMaxQuota.split("=|;", -1);
        String[] headerCurrentUsageWords = headerCurrentUsage.split("=|;", -1);
        for (int i = 0; i < headerMaxQuotaWords.length; ++i) {
            if (headerMaxQuotaWords[i].equalsIgnoreCase("databases")) {
                this.quotaHeaders.put("databases", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("databases", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collections")) {
                this.quotaHeaders.put("collections", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collections", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("users")) {
                this.quotaHeaders.put("users", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("users", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("permissions")) {
                this.quotaHeaders.put("permissions", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("permissions", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collectionSize")) {
                this.quotaHeaders.put("collectionSize", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collectionSize", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("storedProcedures")) {
                this.quotaHeaders.put("storedProcedures", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("storedProcedures", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("triggers")) {
                this.quotaHeaders.put("triggers", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("triggers", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (!headerMaxQuotaWords[i].equalsIgnoreCase("functions")) continue;
            this.quotaHeaders.put("functions", Long.valueOf(headerMaxQuotaWords[i + 1]));
            this.usageHeaders.put("functions", Long.valueOf(headerCurrentUsageWords[i + 1]));
        }
    }

    private static String getValueOrNull(Map<String, String> map, String key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }
}

