/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.ConnectionMode;
import com.microsoft.azure.cosmosdb.MediaReadMode;
import com.microsoft.azure.cosmosdb.RetryOptions;
import java.util.Collection;

public final class ConnectionPolicy {
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MEDIA_REQUEST_TIMEOUT_IN_MILLIS = 300000;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_IN_MILLIS = 60000;
    private static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private static ConnectionPolicy default_policy = null;
    private int requestTimeoutInMillis = 60000;
    private int mediaRequestTimeoutInMillis = 300000;
    private ConnectionMode connectionMode = ConnectionMode.Gateway;
    private MediaReadMode mediaReadMode = MediaReadMode.Buffered;
    private int maxPoolSize = 1000;
    private int idleConnectionTimeoutInMillis = 60000;
    private String userAgentSuffix = "";
    private RetryOptions retryOptions = new RetryOptions();
    private boolean enableEndpointDiscovery = true;
    private Collection<String> preferredLocations;

    public static ConnectionPolicy GetDefault() {
        if (default_policy == null) {
            default_policy = new ConnectionPolicy();
        }
        return default_policy;
    }

    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public void setRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
    }

    public int getMediaRequestTimeoutInMillis() {
        return this.mediaRequestTimeoutInMillis;
    }

    public void setMediaRequestTimeoutInMillis(int mediaRequestTimeoutInMillis) {
        this.mediaRequestTimeoutInMillis = mediaRequestTimeoutInMillis;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
    }

    public MediaReadMode getMediaReadMode() {
        return this.mediaReadMode;
    }

    public void setMediaReadMode(MediaReadMode mediaReadMode) {
        this.mediaReadMode = mediaReadMode;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getIdleConnectionTimeoutInMillis() {
        return this.idleConnectionTimeoutInMillis;
    }

    public void setIdleConnectionTimeoutInMillis(int idleConnectionTimeoutInMillis) {
        this.idleConnectionTimeoutInMillis = idleConnectionTimeoutInMillis;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public void setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public void setRetryOptions(RetryOptions retryOptions) {
        if (retryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.retryOptions = retryOptions;
    }

    public boolean getEnableEndpointDiscovery() {
        return this.enableEndpointDiscovery;
    }

    public void setEnableEndpointDiscovery(boolean enableEndpointDiscovery) {
        this.enableEndpointDiscovery = enableEndpointDiscovery;
    }

    public Collection<String> getPreferredLocations() {
        return this.preferredLocations;
    }

    public void setPreferredLocations(Collection<String> preferredLocations) {
        this.preferredLocations = preferredLocations;
    }

    public String toString() {
        return "ConnectionPolicy [requestTimeoutInMillis=" + this.requestTimeoutInMillis + ", mediaRequestTimeoutInMillis=" + this.mediaRequestTimeoutInMillis + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", mediaReadMode=" + (Object)((Object)this.mediaReadMode) + ", maxPoolSize=" + this.maxPoolSize + ", idleConnectionTimeoutInMillis=" + this.idleConnectionTimeoutInMillis + ", userAgentSuffix=" + this.userAgentSuffix + ", retryOptions=" + this.retryOptions + ", enableEndpointDiscovery=" + this.enableEndpointDiscovery + ", preferredLocations=" + this.preferredLocations + "]";
    }
}

