/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;

final class AzureAsyncOperation {
    static final int DEFAULT_DELAY = 30;
    static final String SUCCESS_STATUS = "Succeeded";
    static final String IN_PROGRESS_STATUS = "InProgress";
    static final String FAILED_STATUS = "Failed";
    static final String CANCELED_STATUS = "Canceled";
    private String status;
    private CloudError error;
    private String rawString;

    AzureAsyncOperation() {
    }

    static List<String> failedStatuses() {
        return Arrays.asList(FAILED_STATUS, CANCELED_STATUS);
    }

    static List<String> terminalStatuses() {
        return Arrays.asList(FAILED_STATUS, CANCELED_STATUS, SUCCESS_STATUS);
    }

    String status() {
        return this.status;
    }

    void setStatus(String status) {
        this.status = status;
    }

    CloudError getError() {
        return this.error;
    }

    void setError(CloudError error) {
        this.error = error;
    }

    String rawString() {
        return this.rawString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AzureAsyncOperation fromResponse(SerializerAdapter<?> serializerAdapter, Response<ResponseBody> response) throws CloudException {
        AzureAsyncOperation asyncOperation = null;
        String rawString = null;
        if (response.body() != null) {
            try {
                rawString = ((ResponseBody)response.body()).string();
                asyncOperation = (AzureAsyncOperation)serializerAdapter.deserialize(rawString, AzureAsyncOperation.class);
                asyncOperation.rawString = rawString;
            }
            catch (IOException iOException) {
            }
            finally {
                ((ResponseBody)response.body()).close();
            }
        }
        if (asyncOperation == null || asyncOperation.status() == null) {
            throw new CloudException("polling response does not contain a valid body: " + rawString, response);
        }
        return asyncOperation;
    }
}

