/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.auth.AcquireTokenFunction;
import com.microsoft.azure.auth.AzureCredential;
import com.microsoft.azure.auth.exception.AzureLoginTimeoutException;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class AzureContextExecutor {
    private String baseUrl;
    private AcquireTokenFunction acquireTokenFunc;

    public AzureContextExecutor(String baseUrl, AcquireTokenFunction acquireTokenFunc) {
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("Parameter 'baseUrl' cannot be empty.");
        }
        if (acquireTokenFunc == null) {
            throw new IllegalArgumentException("Parameter 'acquireTokenFunc' cannot be null.");
        }
        this.baseUrl = baseUrl;
        this.acquireTokenFunc = acquireTokenFunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureCredential execute() throws MalformedURLException, InterruptedException, ExecutionException, AzureLoginTimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            AuthenticationContext authenticationContext = new AuthenticationContext(this.baseUrl, true, executorService);
            AuthenticationResult result = this.acquireTokenFunc.acquire(authenticationContext);
            if (result == null) {
                AzureCredential azureCredential = null;
                return azureCredential;
            }
            AzureCredential azureCredential = AzureCredential.fromAuthenticationResult(result);
            return azureCredential;
        }
        finally {
            executorService.shutdown();
        }
    }
}

