/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.google.gson.JsonSyntaxException;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureCredential;
import com.microsoft.azure.auth.AzureLoginHelper;
import com.microsoft.azure.auth.AzureServicePrincipleAuthHelper;
import com.microsoft.azure.auth.configuration.AuthConfiguration;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.auth.exception.DesktopNotSupportedException;
import com.microsoft.azure.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.credentials.AzureCliCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.MSICredentials;
import com.microsoft.azure.maven.common.utils.JsonUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AzureAuthHelper {
    public static AzureCredential oAuthLogin(AzureEnvironment env) throws AzureLoginFailureException, DesktopNotSupportedException, InterruptedException, ExecutionException {
        return AzureLoginHelper.oAuthLogin(env);
    }

    public static AzureCredential deviceLogin(AzureEnvironment env) throws AzureLoginFailureException, MalformedURLException, InterruptedException, ExecutionException {
        return AzureLoginHelper.deviceLogin(env);
    }

    public static AzureCredential refreshToken(AzureEnvironment env, String refreshToken) throws MalformedURLException, InterruptedException, ExecutionException {
        return AzureLoginHelper.refreshToken(env, refreshToken);
    }

    public static AzureEnvironment getAzureEnvironment(String environment) {
        if (StringUtils.isEmpty((CharSequence)environment)) {
            return AzureEnvironment.AZURE;
        }
        switch (environment.toUpperCase(Locale.ENGLISH)) {
            case "AZURE_CHINA": 
            case "AZURECHINACLOUD": {
                return AzureEnvironment.AZURE_CHINA;
            }
            case "AZURE_GERMANY": 
            case "AZUREGERMANCLOUD": {
                return AzureEnvironment.AZURE_GERMANY;
            }
            case "AZURE_US_GOVERNMENT": 
            case "AZUREUSGOVERNMENT": {
                return AzureEnvironment.AZURE_US_GOVERNMENT;
            }
        }
        return AzureEnvironment.AZURE;
    }

    public static boolean validateEnvironment(String environment) {
        if (StringUtils.isBlank((CharSequence)environment)) {
            return true;
        }
        switch (environment.toUpperCase(Locale.ENGLISH)) {
            case "AZURE_CHINA": 
            case "AZURECHINACLOUD": 
            case "AZURE_GERMANY": 
            case "AZUREGERMANCLOUD": 
            case "AZURE_US_GOVERNMENT": 
            case "AZUREUSGOVERNMENT": 
            case "AZURE": 
            case "AZURE_CLOUD": {
                return true;
            }
        }
        return false;
    }

    public static File getAzureSecretFile() {
        return new File(AzureAuthHelper.getAzureConfigFolder(), "azure-secret.json");
    }

    public static File getAzureConfigFolder() {
        return StringUtils.isNotBlank((CharSequence)System.getenv("AZURE_CONFIG_DIR")) ? new File(System.getenv("AZURE_CONFIG_DIR")) : Paths.get(System.getProperty("user.home"), ".azure").toFile();
    }

    public static boolean existsAzureSecretFile() {
        File azureSecretFile = AzureAuthHelper.getAzureSecretFile();
        return azureSecretFile.exists() && azureSecretFile.isFile() && azureSecretFile.length() > 0L;
    }

    public static boolean deleteAzureSecretFile() {
        if (AzureAuthHelper.existsAzureSecretFile()) {
            return FileUtils.deleteQuietly((File)AzureAuthHelper.getAzureSecretFile());
        }
        return false;
    }

    public static void writeAzureCredentials(AzureCredential cred, File file) throws IOException {
        if (cred == null) {
            throw new IllegalArgumentException("Parameter 'cred' cannot be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be null.");
        }
        FileUtils.writeStringToFile((File)file, (String)JsonUtils.toJson((Object)cred), (String)"utf8");
    }

    public static AzureCredential readAzureCredentials() throws IOException {
        return AzureAuthHelper.readAzureCredentials(AzureAuthHelper.getAzureSecretFile());
    }

    public static AzureCredential readAzureCredentials(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be null.");
        }
        String jsonStr = FileUtils.readFileToString((File)file, (String)"utf8");
        return (AzureCredential)JsonUtils.fromJson((String)jsonStr, AzureCredential.class);
    }

    public static AzureTokenCredentials getMavenAzureLoginCredentials() throws IOException {
        AzureCredential credentials = AzureAuthHelper.readAzureCredentials(AzureAuthHelper.getAzureSecretFile());
        AzureEnvironment env = AzureAuthHelper.getAzureEnvironment(credentials.getEnvironment());
        return AzureAuthHelper.getMavenAzureLoginCredentials(credentials, env);
    }

    public static AzureTokenCredentials getMavenAzureLoginCredentials(final AzureCredential credentials, final AzureEnvironment env) {
        AzureTokenCredentials azureTokenCredentials = new AzureTokenCredentials(env, null){

            public String getToken(String resource) throws IOException {
                String accessToken = credentials.getAccessToken();
                String accessTokenWithoutSignature = accessToken.substring(0, accessToken.lastIndexOf(46) + 1);
                try {
                    Jwt jwtToken = Jwts.parser().parseClaimsJwt(accessTokenWithoutSignature);
                    if (((Claims)jwtToken.getBody()).getExpiration().after(DateUtils.addMinutes((Date)new Date(), (int)1))) {
                        return accessToken;
                    }
                }
                catch (ExpiredJwtException jwtToken) {
                    // empty catch block
                }
                try {
                    AzureCredential newCredentials = AzureAuthHelper.refreshToken(env, credentials.getRefreshToken());
                    credentials.setAccessToken(newCredentials.getAccessToken());
                    AzureAuthHelper.writeAzureCredentials(credentials, AzureAuthHelper.getAzureSecretFile());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof AuthenticationException) {
                        throw (AuthenticationException)e.getCause();
                    }
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(String.format("Error happened during refreshing access token, due to error: %s.", e.getMessage()));
                }
                return credentials.getAccessToken();
            }
        };
        if (StringUtils.isNotBlank((CharSequence)credentials.getDefaultSubscription())) {
            azureTokenCredentials.withDefaultSubscriptionId(credentials.getDefaultSubscription());
        }
        return azureTokenCredentials;
    }

    public static AzureTokenCredentials getAzureTokenCredentials(AuthConfiguration configuration) throws InvalidConfigurationException, IOException {
        if (configuration != null) {
            return AzureServicePrincipleAuthHelper.getAzureServicePrincipleCredentials(configuration);
        }
        if (AzureAuthHelper.existsAzureSecretFile()) {
            try {
                return AzureAuthHelper.getMavenAzureLoginCredentials();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (AzureAuthHelper.isInCloudShell()) {
            return new MSICredentials();
        }
        File credentialParent = AzureAuthHelper.getAzureConfigFolder();
        if (credentialParent.exists() && credentialParent.isDirectory()) {
            File azureProfile = new File(credentialParent, "azureProfile.json");
            File accessTokens = new File(credentialParent, "accessTokens.json");
            if (azureProfile.exists() && accessTokens.exists()) {
                try {
                    List tokens = (List)JsonUtils.fromJson((String)FileUtils.readFileToString((File)accessTokens, (String)"utf8"), List.class);
                    if (tokens.isEmpty()) {
                        return null;
                    }
                    Wrapper wrapper = (Wrapper)JsonUtils.fromJson((String)FileUtils.readFileToString((File)azureProfile, (String)"utf8"), Wrapper.class);
                    if (wrapper.subscriptions == null || wrapper.subscriptions.isEmpty()) {
                        return null;
                    }
                    AzureCliCredentials azureCliCredentials = AzureCliCredentials.create((File)azureProfile, (File)accessTokens);
                    if (azureCliCredentials.clientId() != null) {
                        return azureCliCredentials;
                    }
                    return AzureServicePrincipleAuthHelper.getCredentialFromAzureCliWithServicePrincipal();
                }
                catch (JsonSyntaxException | IOException throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static boolean isInCloudShell() {
        return System.getenv("ACC_CLOUD") != null;
    }

    private AzureAuthHelper() {
    }

    static class Wrapper {
        List<Map> subscriptions;

        Wrapper() {
        }
    }
}

