/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.models.implementation;

import com.microsoft.azure.arm.dag.FunctionalTaskItem;
import com.microsoft.azure.arm.dag.IndexableTaskItem;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.model.Appliable;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.Executable;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.model.Refreshable;
import com.microsoft.azure.arm.resources.models.ExternalChildResource;
import com.microsoft.azure.arm.resources.models.implementation.ChildResourceImpl;
import com.microsoft.azure.arm.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public abstract class ExternalChildResourceImpl<FluentModelT extends Indexable, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ChildResourceImpl<InnerModelT, ParentImplT, ParentT>
implements Appliable<FluentModelT>,
Creatable<FluentModelT>,
TaskGroup.HasTaskGroup,
ExternalChildResource<FluentModelT, ParentT>,
Refreshable<FluentModelT> {
    private PendingOperation pendingOperation = PendingOperation.None;
    private final String name;
    private final ExternalChildActionTaskItem childAction;

    protected ExternalChildResourceImpl(String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(this);
        this.name = name;
    }

    protected ExternalChildResourceImpl(String key, String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(key, this);
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public PendingOperation pendingOperation() {
        return this.pendingOperation;
    }

    public void setPendingOperation(PendingOperation pendingOperation) {
        this.pendingOperation = pendingOperation;
    }

    public void clear() {
        this.setPendingOperation(PendingOperation.None);
        this.childAction.clear();
    }

    @Override
    public TaskGroup taskGroup() {
        return this.childAction.taskGroup();
    }

    protected final FluentModelT prepareUpdate() {
        this.setPendingOperation(PendingOperation.ToBeCreated);
        return (FluentModelT)this;
    }

    public abstract Observable<FluentModelT> createResourceAsync();

    public abstract Observable<FluentModelT> updateResourceAsync();

    public abstract Observable<Void> deleteResourceAsync();

    public String childResourceKey() {
        return this.name();
    }

    @Override
    public final FluentModelT refresh() {
        return (FluentModelT)((Indexable)this.refreshAsync().toBlocking().last());
    }

    @Override
    public Observable<FluentModelT> refreshAsync() {
        final ExternalChildResourceImpl self = this;
        return this.getInnerAsync().map(new Func1<InnerModelT, FluentModelT>(){

            public FluentModelT call(InnerModelT innerModelT) {
                self.setInner(innerModelT);
                return self;
            }
        });
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup().addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup().addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addeDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    protected String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup().addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected void addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        this.addPostRunDependent(dependency);
    }

    public void beforeGroupCreateOrUpdate() {
    }

    @Override
    public Observable<Indexable> createAsync() {
        return this.taskGroup().invokeAsync(this.taskGroup().newInvocationContext());
    }

    @Override
    public FluentModelT create() {
        return (FluentModelT)((Indexable)Utils.rootResource(this.createAsync()).toBlocking().single());
    }

    @Override
    public ServiceFuture<FluentModelT> createAsync(ServiceCallback<FluentModelT> callback) {
        return ServiceFuture.fromBody(Utils.rootResource(this.createAsync()), callback);
    }

    @Override
    public Observable<FluentModelT> applyAsync() {
        return this.taskGroup().invokeAsync(this.taskGroup().newInvocationContext()).last().map(new Func1<Indexable, FluentModelT>(){

            public FluentModelT call(Indexable indexable) {
                return indexable;
            }
        });
    }

    @Override
    public FluentModelT apply() {
        return (FluentModelT)((Indexable)this.applyAsync().toBlocking().last());
    }

    @Override
    public ServiceFuture<FluentModelT> applyAsync(ServiceCallback<FluentModelT> callback) {
        return ServiceFuture.fromBody(this.applyAsync(), callback);
    }

    protected abstract Observable<InnerModelT> getInnerAsync();

    protected Completable afterPostRunAsync(boolean isGroupFaulted) {
        return Completable.complete();
    }

    private class ExternalChildActionTaskItem
    extends IndexableTaskItem {
        private final ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild;

        ExternalChildActionTaskItem(ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            this.externalChild = externalChild;
        }

        ExternalChildActionTaskItem(String key, ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            super(key);
            this.externalChild = externalChild;
        }

        @Override
        public void beforeGroupInvoke() {
            this.externalChild.beforeGroupCreateOrUpdate();
        }

        @Override
        public Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
            switch (this.externalChild.pendingOperation()) {
                case ToBeCreated: {
                    return this.externalChild.createResourceAsync().doOnNext(new Action1<FluentModelT>(){

                        public void call(FluentModelT createdExternalChild) {
                            ExternalChildActionTaskItem.this.externalChild.setPendingOperation(PendingOperation.None);
                        }
                    }).map(new Func1<FluentModelT, Indexable>(){

                        public Indexable call(FluentModelT createdExternalChild) {
                            return createdExternalChild;
                        }
                    });
                }
                case ToBeUpdated: {
                    return this.externalChild.updateResourceAsync().doOnNext(new Action1<FluentModelT>(){

                        public void call(FluentModelT createdExternalChild) {
                            ExternalChildActionTaskItem.this.externalChild.setPendingOperation(PendingOperation.None);
                        }
                    }).map(new Func1<FluentModelT, Indexable>(){

                        public Indexable call(FluentModelT updatedExternalChild) {
                            return updatedExternalChild;
                        }
                    });
                }
                case ToBeRemoved: {
                    return this.externalChild.deleteResourceAsync().doOnNext((Action1)new Action1<Void>(){

                        public void call(Void aVoid) {
                            ExternalChildActionTaskItem.this.externalChild.setPendingOperation(PendingOperation.None);
                        }
                    }).map((Func1)new Func1<Void, Indexable>(){

                        public Indexable call(Void aVoid) {
                            return ExternalChildActionTaskItem.this.voidIndexable();
                        }
                    });
                }
            }
            return Observable.error((Throwable)new IllegalStateException("No action pending on child resource: " + this.externalChild.name + ", invokeAsync should not be called "));
        }

        @Override
        public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
            return this.externalChild.afterPostRunAsync(isGroupFaulted);
        }
    }

    public static enum PendingOperation {
        None,
        ToBeCreated,
        ToBeUpdated,
        ToBeRemoved;

    }
}

