/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.collection.implementation;

import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.resources.models.ExternalChildResource;
import com.microsoft.azure.arm.resources.models.implementation.ExternalChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public abstract class ExternalChildResourceCollectionImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT> {
    private final ParentImplT parent;
    private final TaskGroup parentTaskGroup;
    protected ConcurrentMap<String, FluentModelTImpl> childCollection = new ConcurrentSkipListMap<String, FluentModelTImpl>();
    private boolean isPostRunMode;
    protected final String childResourceName;

    protected ExternalChildResourceCollectionImpl(ParentImplT parent, TaskGroup parentTaskGroup, String childResourceName) {
        this.parent = parent;
        this.parentTaskGroup = parentTaskGroup;
        this.childResourceName = childResourceName;
        this.isPostRunMode = true;
    }

    public void enablePostRunMode() {
        this.isPostRunMode = true;
    }

    public void enableCommitMode() {
        this.isPostRunMode = false;
    }

    public void clear() {
        for (ExternalChildResourceImpl child : this.childCollection.values()) {
            child.clear();
        }
        this.childCollection.clear();
    }

    protected FluentModelTImpl prepareForFutureCommitOrPostRun(FluentModelTImpl childResource) {
        if (this.isPostRunMode) {
            if (!((ExternalChildResourceImpl)childResource).taskGroup().dependsOn(this.parentTaskGroup)) {
                this.parentTaskGroup.addPostRunDependentTaskGroup(((ExternalChildResourceImpl)childResource).taskGroup());
            }
            return childResource;
        }
        return childResource;
    }

    public Observable<FluentModelTImpl> commitAsync() {
        if (this.isPostRunMode) {
            return Observable.error((Throwable)new IllegalStateException("commitAsync() cannot be invoked when 'post run' mode is enabled"));
        }
        final ExternalChildResourceCollectionImpl self = this;
        ArrayList<ExternalChildResourceImpl> items = new ArrayList<ExternalChildResourceImpl>();
        for (ExternalChildResourceImpl item : this.childCollection.values()) {
            items.add(item);
        }
        final List exceptionsList = Collections.synchronizedList(new ArrayList());
        Observable deleteStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).deleteResourceAsync().map(new Func1<Void, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(Void response) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>(){

                    public void call(FluentModelTImpl childResource) {
                        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                        self.childCollection.remove(((ExternalChildResourceImpl)childResource).name());
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<FluentModelTImpl>>(){

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        Observable createStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).createResourceAsync().map(new Func1<FluentModelT, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(FluentModelT fluentModelT) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public void call(FluentModelTImpl fluentModelT) {
                        this.val$childResource.setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends FluentModelTImpl>>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        self.childCollection.remove(this.val$childResource.name());
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        Observable updateStream = Observable.from(items).filter(new Func1<FluentModelTImpl, Boolean>(){

            public Boolean call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeUpdated;
            }
        }).flatMap(new Func1<FluentModelTImpl, Observable<FluentModelTImpl>>(){

            public Observable<FluentModelTImpl> call(FluentModelTImpl childResource) {
                return ((ExternalChildResourceImpl)childResource).updateResourceAsync().map(new Func1<FluentModelT, FluentModelTImpl>((ExternalChildResourceImpl)childResource){
                    final /* synthetic */ ExternalChildResourceImpl val$childResource;
                    {
                        this.val$childResource = externalChildResourceImpl;
                    }

                    public FluentModelTImpl call(FluentModelT e) {
                        return this.val$childResource;
                    }
                }).doOnNext(new Action1<FluentModelTImpl>(){

                    public void call(FluentModelTImpl childResource) {
                        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends FluentModelTImpl>>(){

                    public Observable<FluentModelTImpl> call(Throwable throwable) {
                        exceptionsList.add(throwable);
                        return Observable.empty();
                    }
                });
            }
        });
        final PublishSubject aggregatedErrorStream = PublishSubject.create();
        Observable operationsStream = Observable.merge((Observable)deleteStream, (Observable)createStream, (Observable)updateStream).doOnTerminate(new Action0(){

            public void call() {
                if (ExternalChildResourceCollectionImpl.this.clearAfterCommit()) {
                    self.childCollection.clear();
                }
                if (exceptionsList.isEmpty()) {
                    aggregatedErrorStream.onCompleted();
                } else {
                    aggregatedErrorStream.onError((Throwable)new CompositeException((Collection)exceptionsList));
                }
            }
        });
        Observable stream = Observable.concat((Observable)operationsStream, (Observable)aggregatedErrorStream);
        return stream;
    }

    public Observable<List<FluentModelTImpl>> commitAndGetAllAsync() {
        return this.commitAsync().collect(new Func0<List<FluentModelTImpl>>(){

            public List<FluentModelTImpl> call() {
                return new ArrayList();
            }
        }, new Action2<List<FluentModelTImpl>, FluentModelTImpl>(){

            public void call(List<FluentModelTImpl> state, FluentModelTImpl item) {
                state.add(item);
            }
        });
    }

    protected FluentModelTImpl find(String key) {
        for (Map.Entry entry : this.childCollection.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(key)) continue;
            return (FluentModelTImpl)((ExternalChildResourceImpl)entry.getValue());
        }
        return null;
    }

    protected ParentImplT parent() {
        return this.parent;
    }

    protected abstract boolean clearAfterCommit();
}

