/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.model.implementation;

import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.dag.TaskItem;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.utils.SdkContext;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class ExecuteTask<ResultT extends Indexable>
implements TaskItem {
    private Executor<ResultT> executor;
    private ResultT result;

    public ExecuteTask(Executor<ResultT> executor) {
        this.executor = executor;
    }

    public ResultT result() {
        return this.result;
    }

    @Override
    public void beforeGroupInvoke() {
        this.executor.beforeGroupExecute();
    }

    @Override
    public boolean isHot() {
        return this.executor.isHot();
    }

    @Override
    public Observable<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        return this.executor.executeWorkAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResultT>(){

            public void call(ResultT resultT) {
                ExecuteTask.this.result = resultT;
            }
        }).map(new Func1<ResultT, Indexable>(){

            public Indexable call(ResultT resourceT) {
                return resourceT;
            }
        });
    }

    @Override
    public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return this.executor.afterPostRunAsync(isGroupFaulted);
    }

    public static interface Executor<T extends Indexable> {
        public void beforeGroupExecute();

        public boolean isHot();

        public Observable<T> executeWorkAsync();

        public Completable afterPostRunAsync(boolean var1);
    }
}

