/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.internal.agent.AbstractSdkBridge;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.correlation.TelemetryCorrelationUtils;
import com.microsoft.applicationinsights.web.internal.correlation.TraceContextCorrelation;
import com.microsoft.applicationinsights.web.internal.correlation.tracecontext.Traceparent;

class SdkBridgeImpl
extends AbstractSdkBridge<RequestTelemetryContext> {
    SdkBridgeImpl(TelemetryClient client) {
        super(client);
    }

    public void bindRequestTelemetryContext(RequestTelemetryContext requestTelemetryContext) {
        ThreadContext.setRequestTelemetryContext(requestTelemetryContext);
    }

    public void unbindRequestTelemetryContext() {
        ThreadContext.remove();
    }

    public void setOperationName(RequestTelemetryContext requestTelemetryContext, String operationName) {
        RequestTelemetry requestTelemetry = requestTelemetryContext.getHttpRequestTelemetry();
        if (requestTelemetry.isAllowAgentToOverrideName()) {
            requestTelemetry.setName(operationName);
        }
    }

    public String generateChildDependencyTarget(String requestContext, boolean w3c) {
        if (w3c) {
            return TraceContextCorrelation.generateChildDependencyTarget(requestContext);
        }
        return TelemetryCorrelationUtils.generateChildDependencyTarget(requestContext);
    }

    public <C> String propagate(SdkBridge.Setter<C> setter, C carrier, boolean w3c, boolean w3cBackCompat) {
        if (w3c) {
            Traceparent traceparent = TraceContextCorrelation.generateChildDependencyTraceparentObj();
            if (traceparent == null) {
                return new Traceparent().getSpanId();
            }
            String tracestate = TraceContextCorrelation.retriveTracestate();
            setter.put(carrier, "traceparent", traceparent.toString());
            if (w3cBackCompat) {
                setter.put(carrier, "Request-Id", "|" + traceparent.getTraceId() + "." + traceparent.getSpanId() + ".");
                setter.put(carrier, "Request-Context", TelemetryCorrelationUtils.retrieveApplicationCorrelationId());
            }
            if (tracestate != null) {
                setter.put(carrier, "tracestate", tracestate);
            }
            return traceparent.getSpanId();
        }
        String outgoingSpanId = TelemetryCorrelationUtils.generateChildDependencyId();
        String correlationContext = TelemetryCorrelationUtils.retrieveCorrelationContext();
        String appCorrelationId = TelemetryCorrelationUtils.retrieveApplicationCorrelationId();
        setter.put(carrier, "Request-Id", outgoingSpanId);
        setter.put(carrier, "Correlation-Context", correlationContext);
        setter.put(carrier, "Request-Context", appCorrelationId);
        return outgoingSpanId;
    }
}

