/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config.connection;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Splitter;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.config.connection.InvalidConnectionStringException;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;

public class ConnectionString {
    @VisibleForTesting
    static final int CONNECTION_STRING_MAX_LENGTH = 4096;

    private ConnectionString() {
    }

    public static void parseInto(String connectionString, TelemetryConfiguration targetConfig) throws InvalidConnectionStringException {
        TreeMap<String, String> kvps;
        if (connectionString.length() > 4096) {
            throw new InvalidConnectionStringException("ConnectionString values with more than 4096 characters are not allowed.");
        }
        try {
            kvps = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            kvps.putAll(Splitter.on(';').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split(connectionString));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConnectionStringException("Could not parse connection string.");
        }
        ConnectionString.mapToConnectionConfiguration(kvps, targetConfig);
    }

    private static void mapToConnectionConfiguration(Map<String, String> kvps, TelemetryConfiguration config) throws InvalidConnectionStringException {
        String snapshotEndpoint;
        String profilerEndpoint;
        String ingestionEndpoint;
        String liveEndpoint;
        String instrumentationKey = kvps.get("InstrumentationKey");
        if (Strings.isNullOrEmpty(instrumentationKey)) {
            throw new InvalidConnectionStringException("Missing 'InstrumentationKey'");
        }
        if (!Strings.isNullOrEmpty(config.getInstrumentationKey())) {
            InternalLogger.INSTANCE.warn("Connection string is overriding previously configured instrumentation key.", new Object[0]);
        }
        config.setInstrumentationKey(instrumentationKey);
        String suffix = kvps.get("EndpointSuffix");
        if (!Strings.isNullOrEmpty(suffix)) {
            try {
                config.getEndpointProvider().setIngestionEndpoint(ConnectionString.constructSecureEndpoint("dc", suffix));
                config.getEndpointProvider().setLiveEndpoint(ConnectionString.constructSecureEndpoint("live", suffix));
                config.getEndpointProvider().setProfilerEndpoint(ConnectionString.constructSecureEndpoint("profiler", suffix));
                config.getEndpointProvider().setSnapshotEndpoint(ConnectionString.constructSecureEndpoint("snapshot", suffix));
            }
            catch (URISyntaxException e) {
                throw new InvalidConnectionStringException("EndpointSuffix is invalid: " + suffix, e);
            }
        }
        if (!Strings.isNullOrEmpty(liveEndpoint = kvps.get("LiveEndpoint"))) {
            config.getEndpointProvider().setLiveEndpoint(ConnectionString.toUriOrThrow(liveEndpoint, "LiveEndpoint"));
        }
        if (!Strings.isNullOrEmpty(ingestionEndpoint = kvps.get("IngestionEndpoint"))) {
            config.getEndpointProvider().setIngestionEndpoint(ConnectionString.toUriOrThrow(ingestionEndpoint, "IngestionEndpoint"));
        }
        if (!Strings.isNullOrEmpty(profilerEndpoint = kvps.get("ProfilerEndpoint"))) {
            config.getEndpointProvider().setProfilerEndpoint(ConnectionString.toUriOrThrow(profilerEndpoint, "ProfilerEndpoint"));
        }
        if (!Strings.isNullOrEmpty(snapshotEndpoint = kvps.get("SnapshotEndpoint"))) {
            config.getEndpointProvider().setSnapshotEndpoint(ConnectionString.toUriOrThrow(snapshotEndpoint, "SnapshotEndpoint"));
        }
    }

    private static URI toUriOrThrow(String uri, String field) throws InvalidConnectionStringException {
        try {
            URI result = new URI(uri);
            String scheme = result.getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new InvalidConnectionStringException(field + " must specify supported protocol, either 'http' or 'https': \"" + uri + "\"");
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new InvalidConnectionStringException(field + " is invalid: \"" + uri + "\"", e);
        }
    }

    @VisibleForTesting
    static URI constructSecureEndpoint(String prefix, String suffix) throws URISyntaxException {
        return new URI("https://" + StringUtils.strip(prefix, ".") + "." + StringUtils.strip(suffix, "."));
    }

    public static class Defaults {
        public static final String INGESTION_ENDPOINT = "https://dc.services.visualstudio.com";
        public static final String LIVE_ENDPOINT = "https://rt.services.visualstudio.com";
        public static final String PROFILER_ENDPOINT = "https://agent.azureserviceprofiler.net";
        public static final String SNAPSHOT_ENDPOINT = "https://agent.azureserviceprofiler.net";

        private Defaults() {
        }
    }

    @VisibleForTesting
    static class EndpointPrefixes {
        static final String INGESTION_ENDPOINT_PREFIX = "dc";
        static final String LIVE_ENDPOINT_PREFIX = "live";
        static final String PROFILER_ENDPOINT_PREFIX = "profiler";
        static final String SNAPSHOT_ENDPOINT_PREFIX = "snapshot";

        private EndpointPrefixes() {
        }
    }

    @VisibleForTesting
    static class Keywords {
        static final String AUTHORIZATION = "Authorization";
        static final String INSTRUMENTATION_KEY = "InstrumentationKey";
        static final String ENDPOINT_SUFFIX = "EndpointSuffix";
        static final String INGESTION_ENDPOINT = "IngestionEndpoint";
        static final String LIVE_ENDPOINT = "LiveEndpoint";
        static final String PROFILER_ENDPOINT = "ProfilerEndpoint";
        static final String SNAPSHOT_ENDPOINT = "SnapshotEndpoint";

        private Keywords() {
        }
    }
}

