/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete.inprocess;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.concrete.TelemetryChannelBase;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryTransmitterFactory;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.channel.ConfiguredTransmitterFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public final class InProcessTelemetryChannel
extends TelemetryChannelBase<String> {
    public InProcessTelemetryChannel(TelemetryConfiguration configuration) {
        super(configuration);
    }

    public InProcessTelemetryChannel(TelemetryConfiguration configuration, String maxTransmissionStorageCapacity, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis, boolean throttling, int maxInstantRetries) {
        super(configuration, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacity, sendIntervalInMillis, throttling, maxInstantRetries);
    }

    public InProcessTelemetryChannel(TelemetryConfiguration configuration, Map<String, String> channelConfig) {
        super(configuration, channelConfig);
    }

    @Deprecated
    public InProcessTelemetryChannel() {
    }

    @Deprecated
    public InProcessTelemetryChannel(String endpointAddress, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis) {
        super(endpointAddress, developerMode, maxTelemetryBufferCapacity, sendIntervalInMillis);
    }

    @Deprecated
    public InProcessTelemetryChannel(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis, boolean throttling, int maxInstantRetries) {
        super(endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacity, sendIntervalInMillis, throttling, maxInstantRetries);
    }

    @Deprecated
    public InProcessTelemetryChannel(Map<String, String> namesAndValues) {
        super(namesAndValues);
    }

    @Override
    protected boolean doSend(Telemetry telemetry) {
        StringWriter writer = new StringWriter();
        JsonTelemetryDataSerializer jsonWriter = null;
        try {
            jsonWriter = new JsonTelemetryDataSerializer(writer);
            telemetry.serialize(jsonWriter);
            jsonWriter.close();
            String asJson = writer.toString();
            this.telemetryBuffer.add(asJson);
            telemetry.reset();
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to serialize Telemetry", new Object[0]);
            InternalLogger.INSTANCE.trace("Stack trace is %s", ExceptionUtils.getStackTrace(e));
            return false;
        }
        return true;
    }

    @Override
    protected ConfiguredTransmitterFactory<String> createTransmitterFactory() {
        return new InProcessTelemetryTransmitterFactory();
    }
}

