/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation.tracecontext;

import com.microsoft.applicationinsights.web.dependencies.http.annotation.Experimental;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Experimental
public class Tracestate {
    private static String KEY_WITHOUT_VENDOR_FORMAT = "[a-z][_0-9a-z\\-\\*\\/]{0,255}";
    private static String KEY_WITH_VENDOR_FORMAT = "[a-z][_0-9a-z\\-\\*\\/]{0,240}@[a-z][_0-9a-z\\-\\*\\/]{0,13}";
    private static String KEY_FORMAT = KEY_WITHOUT_VENDOR_FORMAT + "|" + KEY_WITH_VENDOR_FORMAT;
    private static String VALUE_FORMAT = "[\\x20-\\x2b\\x2d-\\x3c\\x3e-\\x7e]{0,255}[\\x21-\\x2b\\x2d-\\x3c\\x3e-\\x7e]";
    private static Pattern KEY_VALIDATION_RE = Pattern.compile("^" + KEY_FORMAT + "$");
    private static Pattern VALUE_VALIDATION_RE = Pattern.compile("^" + VALUE_FORMAT + "$");
    private static String DELIMITER_FORMAT = "[ \\t]*,[ \\t]*";
    private static String MEMBER_FORMAT = String.format("(%s)(=)(%s)", KEY_FORMAT, VALUE_FORMAT);
    private static Pattern DELIMITER_FORMAT_RE = Pattern.compile(DELIMITER_FORMAT);
    private static Pattern MEMBER_FORMAT_RE = Pattern.compile("^" + MEMBER_FORMAT + "$");
    private static final int MAX_KEY_VALUE_PAIRS = 32;
    private LinkedHashMap<String, String> internalList = new LinkedHashMap(32);
    private String internalString = null;

    public Tracestate(String input) {
        String[] values;
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        for (String item : values = DELIMITER_FORMAT_RE.split(input)) {
            Matcher m = MEMBER_FORMAT_RE.matcher(item);
            if (!m.find()) {
                throw new IllegalArgumentException(String.format("invalid string %s in tracestate", item));
            }
            String key = m.group(1);
            String value = m.group(3);
            if (this.internalList.get(key) != null) {
                throw new IllegalArgumentException(String.format("duplicated keys %s in tracestate", key));
            }
            this.internalList.put(key, value);
        }
        if (this.internalList.size() > 32) {
            throw new IllegalArgumentException(String.format("cannot have more than %d key-value pairs", 32));
        }
        this.internalString = this.toInternalString();
    }

    public Tracestate(Tracestate parent, String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!KEY_VALIDATION_RE.matcher(key).find()) {
            throw new IllegalArgumentException("invalid key format");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!VALUE_VALIDATION_RE.matcher(value).find()) {
            throw new IllegalArgumentException("invalid value format");
        }
        this.internalList.put(key, value);
        if (parent != null) {
            for (String k : parent.internalList.keySet()) {
                this.internalList.put(k, parent.internalList.get(k));
            }
            this.internalList.put(key, value);
        }
        this.internalString = this.toInternalString();
    }

    public String get(String key) {
        return this.internalList.get(key);
    }

    public String toString() {
        return this.internalString;
    }

    public static Tracestate fromString(String s) {
        return new Tracestate(s);
    }

    private String toInternalString() {
        boolean isFirst = true;
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Map.Entry<String, String> entry : this.internalList.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

