/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.protocol;

import com.microsoft.applicationinsights.web.dependencies.http.HttpConnection;
import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpHost;
import com.microsoft.applicationinsights.web.dependencies.http.HttpInetConnection;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequestInterceptor;
import com.microsoft.applicationinsights.web.dependencies.http.HttpVersion;
import com.microsoft.applicationinsights.web.dependencies.http.ProtocolException;
import com.microsoft.applicationinsights.web.dependencies.http.ProtocolVersion;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpCoreContext;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

