/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.channel.sampling.AdaptiveTelemetrySampler;
import com.microsoft.applicationinsights.internal.channel.sampling.FixedRateTelemetrySampler;
import com.microsoft.applicationinsights.internal.config.AdaptiveSamplerXmlElement;
import com.microsoft.applicationinsights.internal.config.FixedSamplerXmlElement;
import com.microsoft.applicationinsights.internal.config.SamplerXmlElement;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;

final class TelemetrySamplerInitializer {
    TelemetrySamplerInitializer() {
    }

    public TelemetrySampler getSampler(SamplerXmlElement sampler) {
        if (sampler == null) {
            return null;
        }
        FixedSamplerXmlElement fixedSamplerXmlElement = sampler.getFixedSamplerXmlElement();
        TelemetrySampler telemetrySampler = null;
        if (fixedSamplerXmlElement != null) {
            Double percentage = null;
            String percentageAsString = fixedSamplerXmlElement.getSamplingPercentage();
            if (percentageAsString != null) {
                percentageAsString = percentageAsString.trim();
            }
            if (!LocalStringsUtils.isNullOrEmpty(percentageAsString)) {
                try {
                    percentage = Double.valueOf(percentageAsString);
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.error("Failed to parse %s, exception : %s", percentageAsString, ExceptionUtils.getStackTrace(e));
                }
            }
            telemetrySampler = new FixedRateTelemetrySampler();
            telemetrySampler.setIncludeTypes(fixedSamplerXmlElement.getIncludeTypes());
            telemetrySampler.setExcludeTypes(fixedSamplerXmlElement.getExcludeTypes());
            telemetrySampler.setSamplingPercentage(percentage);
        } else {
            AdaptiveSamplerXmlElement adaptiveSamplerXmlElement = sampler.getAdaptiveSamplerXmlElement();
            if (adaptiveSamplerXmlElement != null) {
                AdaptiveTelemetrySampler adaptiveTelemetrySampler = new AdaptiveTelemetrySampler();
                adaptiveTelemetrySampler.setIncludeTypes(adaptiveSamplerXmlElement.getIncludeTypes());
                adaptiveTelemetrySampler.setExcludeTypes(adaptiveSamplerXmlElement.getExcludeTypes());
                adaptiveTelemetrySampler.initialize(adaptiveSamplerXmlElement.getMaxTelemetryItemsPerSecond(), adaptiveSamplerXmlElement.getEvaluationInterval(), adaptiveSamplerXmlElement.getSamplingPercentageDecreaseTimeout(), adaptiveSamplerXmlElement.getSamplingPercentageIncreaseTimeout(), adaptiveSamplerXmlElement.getMinSamplingPercentage(), adaptiveSamplerXmlElement.getMaxSamplingPercentage(), adaptiveSamplerXmlElement.getInitialSamplingPercentage(), adaptiveSamplerXmlElement.getMovingAverageRatio());
                telemetrySampler = adaptiveTelemetrySampler;
            } else {
                InternalLogger.INSTANCE.error("Could not resolve sampler type. Possible values are 'Fixed' or 'Adaptive'", new Object[0]);
            }
        }
        return telemetrySampler;
    }
}

