/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.cookies;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class Cookie {
    protected static final String RAW_COOKIE_DELIMITER = "|";
    protected static final String RAW_COOKIE_SPLIT_DELIMITER = "\\|";

    public static String formatCookie(String[] values) {
        return StringUtils.join((Object[])values, RAW_COOKIE_DELIMITER);
    }

    public static <E> E getCookie(Class<E> eClass, HttpServletRequest request, String cookieName) {
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        javax.servlet.http.Cookie httpCookie = null;
        for (javax.servlet.http.Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            httpCookie = cookie;
        }
        if (httpCookie == null) {
            return null;
        }
        E instance = null;
        try {
            instance = eClass.getConstructor(javax.servlet.http.Cookie.class).newInstance(httpCookie);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create %s cookie with error: %s", cookieName, e.toString());
        }
        return instance;
    }
}

