/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.internal.agent.AgentBinding;
import com.microsoft.applicationinsights.internal.agent.AgentBridge;
import com.microsoft.applicationinsights.internal.agent.AgentBridgeFactory;
import com.microsoft.applicationinsights.internal.config.WebReflectionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebAppNameContextInitializer;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.SdkBridgeImpl;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.WebModulesContainer;
import com.microsoft.applicationinsights.web.internal.httputils.AIHttpServletListener;
import com.microsoft.applicationinsights.web.internal.httputils.ApplicationInsightsServletExtractor;
import com.microsoft.applicationinsights.web.internal.httputils.HttpServerHandler;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebRequestTrackingFilter
implements Filter {
    static final String FILTER_NAME = "ApplicationInsightsWebFilter";
    private static final String WEB_INF_FOLDER = "WEB-INF/";
    private WebModulesContainer webModulesContainer;
    private TelemetryClient telemetryClient;
    private final List<ThreadLocalCleaner> cleaners = new LinkedList<ThreadLocalCleaner>();
    private String appName;
    private static final String AGENT_LOCATOR_INTERFACE_NAME = "com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler";
    private static final String ALREADY_FILTERED = "AI_FILTER_PROCESSED";
    public static final String APPLICATION_INSIGHTS_CAUGHT_EXCEPTION = "AI_CAUGHT_EXCEPTION";
    HttpServerHandler handler;
    private AgentBridge<RequestTelemetryContext> agentBridge;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            boolean hasAlreadyBeenFiltered;
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            HttpServletResponse httpResponse = (HttpServletResponse)res;
            boolean bl = hasAlreadyBeenFiltered = httpRequest.getAttribute(ALREADY_FILTERED) != null;
            if (hasAlreadyBeenFiltered) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            RequestTelemetryContext requestTelemetryContext = this.handler.handleStart((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            AgentBinding agentBinding = this.agentBridge.isAgentRunning() ? this.agentBridge.bindToThread(requestTelemetryContext, new AgentBridge.ServletRequestInfo(httpRequest.getMethod(), httpRequest.getContextPath(), httpRequest.getServletPath(), httpRequest.getPathInfo(), httpRequest.getRequestURI())) : null;
            try {
                httpRequest.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (IOException | RuntimeException | ServletException e) {
                httpRequest.setAttribute(APPLICATION_INSIGHTS_CAUGHT_EXCEPTION, (Object)e);
                this.handler.handleException((Exception)e);
                throw e;
            }
            finally {
                if (httpRequest.isAsyncStarted()) {
                    AsyncContext context = httpRequest.getAsyncContext();
                    AIHttpServletListener aiHttpServletListener = new AIHttpServletListener(this.handler, requestTelemetryContext, agentBinding);
                    context.addListener((AsyncListener)aiHttpServletListener, (ServletRequest)httpRequest, (ServletResponse)httpResponse);
                } else {
                    this.handler.handleEnd((ServletRequest)httpRequest, (ServletResponse)httpResponse, requestTelemetryContext);
                    if (agentBinding != null) {
                        agentBinding.unbindFromRunawayChildThreads();
                    }
                }
                if (agentBinding != null) {
                    agentBinding.unbindFromMainThread();
                }
                ThreadContext.remove();
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public WebRequestTrackingFilter(String appName) {
        this.appName = appName;
    }

    public void init(FilterConfig config) {
        try {
            long start = System.currentTimeMillis();
            this.appName = this.extractAppName(config.getServletContext());
            TelemetryConfiguration configuration = TelemetryConfiguration.getActive();
            if (configuration == null) {
                InternalLogger.INSTANCE.error("Java SDK configuration cannot be null. Web request tracking filter will be disabled.", new Object[0]);
                return;
            }
            this.configureWebAppNameContextInitializer(this.appName, configuration);
            this.telemetryClient = new TelemetryClient(configuration);
            this.webModulesContainer = new WebModulesContainer(configuration);
            this.handler = new HttpServerHandler(new ApplicationInsightsServletExtractor(), this.webModulesContainer, this.cleaners, this.telemetryClient);
            if (AgentBridgeFactory.isAgentAvailable()) {
                InternalLogger.INSTANCE.info("Agent is running", new Object[0]);
                this.agentBridge = AgentBridgeFactory.create(new AgentBridgeFactory.SdkBridgeFactory(){

                    public SdkBridge create() {
                        return new SdkBridgeImpl(WebRequestTrackingFilter.this.telemetryClient);
                    }
                });
            } else {
                InternalLogger.INSTANCE.info("Agent is not running", new Object[0]);
                this.agentBridge = AgentBridgeFactory.create();
            }
            long end = System.currentTimeMillis();
            InternalLogger.INSTANCE.trace("Initialized Application Insights Filter in %.3fms", end - start);
        }
        catch (Exception e) {
            String filterName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.info("Application Insights filter %s has failed to initialized.\nWeb request tracking filter will be disabled. Exception: %s", filterName, ExceptionUtils.getStackTrace(e));
        }
    }

    private void configureWebAppNameContextInitializer(String appName, TelemetryConfiguration configuration) {
        for (ContextInitializer ci : configuration.getContextInitializers()) {
            if (!(ci instanceof WebAppNameContextInitializer)) continue;
            ((WebAppNameContextInitializer)ci).setAppName(appName);
            return;
        }
    }

    public void destroy() {
    }

    public WebRequestTrackingFilter() {
    }

    private String extractAppName(ServletContext context) {
        String name;
        block9: {
            if (this.appName != null) {
                return this.appName;
            }
            name = null;
            try {
                String contextPath = context.getContextPath();
                if (CommonUtils.isNullOrEmpty(contextPath)) {
                    URL[] jarPaths;
                    for (URL url : jarPaths = ((URLClassLoader)this.getClass().getClassLoader()).getURLs()) {
                        String[] parts;
                        String urlPath = url.getPath();
                        int index = urlPath.lastIndexOf(WEB_INF_FOLDER);
                        if (index == -1 || (parts = (urlPath = urlPath.substring(0, index)).split("/")).length <= 0) continue;
                        name = parts[parts.length - 1];
                        break block9;
                    }
                    break block9;
                }
                name = contextPath.substring(1);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    InternalLogger.INSTANCE.error("Exception while fetching WebApp name: '%s'", ExceptionUtils.getStackTrace(t));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return name;
    }

    static {
        WebReflectionUtils.initialize();
    }
}

