/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client;

import com.microsoft.applicationinsights.web.dependencies.apachecommons.logging.Log;
import com.microsoft.applicationinsights.web.dependencies.http.ConnectionReuseStrategy;
import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpHost;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.Configurable;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpExecutionAware;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpRequestWrapper;
import com.microsoft.applicationinsights.web.dependencies.http.client.protocol.HttpClientContext;
import com.microsoft.applicationinsights.web.dependencies.http.concurrent.BasicFuture;
import com.microsoft.applicationinsights.web.dependencies.http.conn.ConnectionKeepAliveStrategy;
import com.microsoft.applicationinsights.web.dependencies.http.conn.routing.HttpRoute;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.AbstractClientExchangeHandler;
import com.microsoft.applicationinsights.web.dependencies.http.nio.ContentDecoder;
import com.microsoft.applicationinsights.web.dependencies.http.nio.ContentEncoder;
import com.microsoft.applicationinsights.web.dependencies.http.nio.IOControl;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpClientConnection;
import com.microsoft.applicationinsights.web.dependencies.http.nio.conn.NHttpClientConnectionManager;
import com.microsoft.applicationinsights.web.dependencies.http.nio.protocol.HttpAsyncRequestProducer;
import com.microsoft.applicationinsights.web.dependencies.http.nio.protocol.HttpAsyncResponseConsumer;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpProcessor;
import java.io.IOException;

class MinimalClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpClientContext localContext;
    private final BasicFuture<T> resultFuture;
    private final HttpProcessor httpProcessor;

    public MinimalClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpClientContext localContext, BasicFuture<T> resultFuture, NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        super(log, localContext, connmgr, connReuseStrategy, keepaliveStrategy);
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.localContext = localContext;
        this.resultFuture = resultFuture;
        this.httpProcessor = httpProcessor;
    }

    @Override
    void releaseResources() {
        try {
            this.requestProducer.close();
        }
        catch (IOException ex) {
            this.log.debug("I/O error closing request producer", ex);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException ex) {
            this.log.debug("I/O error closing response consumer", ex);
        }
    }

    @Override
    void executionFailed(Exception ex) {
        this.requestProducer.failed(ex);
        this.responseConsumer.failed(ex);
    }

    @Override
    boolean executionCancelled() {
        boolean cancelled = this.responseConsumer.cancel();
        T result = this.responseConsumer.getResult();
        Exception ex = this.responseConsumer.getException();
        if (ex != null) {
            this.resultFuture.failed(ex);
        } else if (result != null) {
            this.resultFuture.completed(result);
        } else {
            this.resultFuture.cancel();
        }
        return cancelled;
    }

    public void start() throws HttpException, IOException {
        RequestConfig config;
        HttpHost target = this.requestProducer.getTarget();
        HttpRequest original = this.requestProducer.generateRequest();
        if (original instanceof HttpExecutionAware) {
            ((HttpExecutionAware)((Object)original)).setCancellable(this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] start execution");
        }
        if (original instanceof Configurable && (config = ((Configurable)((Object)original)).getConfig()) != null) {
            this.localContext.setRequestConfig(config);
        }
        HttpRequestWrapper request = HttpRequestWrapper.wrap(original);
        HttpRoute route = new HttpRoute(target);
        this.setCurrentRequest(request);
        this.setRoute(route);
        this.localContext.setAttribute("http.request", request);
        this.localContext.setAttribute("http.target_host", target);
        this.localContext.setAttribute("http.route", route);
        this.httpProcessor.process(request, (HttpContext)this.localContext);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        this.verifytRoute();
        if (!this.isRouteEstablished()) {
            this.onRouteToTarget();
            this.onRouteComplete();
        }
        NHttpClientConnection localConn = this.getConnection();
        this.localContext.setAttribute("http.connection", localConn);
        RequestConfig config = this.localContext.getRequestConfig();
        if (config.getSocketTimeout() > 0) {
            localConn.setSocketTimeout(config.getSocketTimeout());
        }
        return this.getCurrentRequest();
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] produce content");
        }
        this.requestProducer.produceContent(encoder, ioctrl);
        if (encoder.isCompleted()) {
            this.requestProducer.resetRequest();
        }
    }

    @Override
    public void requestCompleted() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] Request completed");
        }
        this.requestProducer.requestCompleted(this.localContext);
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] Response received " + response.getStatusLine());
        }
        this.localContext.setAttribute("http.response", response);
        this.httpProcessor.process(response, (HttpContext)this.localContext);
        this.setCurrentResponse(response);
        this.responseConsumer.responseReceived(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] Consume content");
        }
        this.responseConsumer.consumeContent(decoder, ioctrl);
        if (!decoder.isCompleted() && this.responseConsumer.isDone()) {
            this.markConnectionNonReusable();
            try {
                this.markCompleted();
                this.releaseConnection();
                this.resultFuture.cancel();
            }
            finally {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseCompleted() throws IOException, HttpException {
        this.manageConnectionPersistence();
        this.responseConsumer.responseCompleted(this.localContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug("[exchange: " + this.getId() + "] Response processed");
        }
        try {
            this.markCompleted();
            this.releaseConnection();
            T result = this.responseConsumer.getResult();
            Exception ex = this.responseConsumer.getException();
            if (ex == null) {
                this.resultFuture.completed(result);
            } else {
                this.resultFuture.failed(ex);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void inputTerminated() {
        this.close();
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

