/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.cookie;

import com.microsoft.applicationinsights.core.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.core.dependencies.http.cookie.CommonCookieAttributeHandler;
import com.microsoft.applicationinsights.core.dependencies.http.cookie.Cookie;
import com.microsoft.applicationinsights.core.dependencies.http.cookie.CookieOrigin;
import com.microsoft.applicationinsights.core.dependencies.http.cookie.MalformedCookieException;
import com.microsoft.applicationinsights.core.dependencies.http.cookie.SetCookie;
import com.microsoft.applicationinsights.core.dependencies.http.impl.cookie.AbstractCookieAttributeHandler;
import com.microsoft.applicationinsights.core.dependencies.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

