/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.spring;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestNameHandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            if (context == null) {
                return true;
            }
            String requestName = this.generateRequestName(request, handler);
            if (requestName == null) {
                return true;
            }
            context.getHttpRequestTelemetry().setName(requestName);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to invoke interceptor '%s' with exception: %s.", ((Object)((Object)this)).getClass().getSimpleName(), e.getMessage());
        }
        return true;
    }

    private String generateRequestName(HttpServletRequest request, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return null;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String controller = handlerMethod.getBeanType().getSimpleName();
        String action = handlerMethod.getMethod().getName();
        String method = request.getMethod();
        return String.format("%s %s/%s", method, controller, action);
    }
}

