/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.ExceptionData;
import com.microsoft.applicationinsights.internal.schemav2.ExceptionDetails;
import com.microsoft.applicationinsights.internal.schemav2.StackFrame;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionHandledAt;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class ExceptionTelemetry
extends BaseSampleSourceTelemetry<ExceptionData> {
    private Double samplingPercentage;
    private final ExceptionData data = new ExceptionData();
    private Throwable throwable;
    private static final String ENVELOPE_NAME = "Exception";
    private static final String BASE_TYPE = "ExceptionData";

    private ExceptionTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public ExceptionTelemetry(Throwable exception, int stackSize) {
        this();
        this.setException(exception, stackSize);
    }

    public ExceptionTelemetry(Throwable exception) {
        this(exception, Integer.MAX_VALUE);
    }

    public Exception getException() {
        return this.throwable instanceof Exception ? (Exception)this.throwable : null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setException(Throwable throwable) {
        this.setException(throwable, Integer.MAX_VALUE);
    }

    public void setException(Throwable throwable, int stackSize) {
        this.throwable = throwable;
        this.updateException(throwable, stackSize);
    }

    @Deprecated
    public ExceptionHandledAt getExceptionHandledAt() {
        return ExceptionHandledAt.Unhandled;
    }

    @Deprecated
    public void setExceptionHandledAt(ExceptionHandledAt value) {
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel == null ? null : com.microsoft.applicationinsights.internal.schemav2.SeverityLevel.values()[severityLevel.getValue()]);
    }

    public SeverityLevel getSeverityLevel() {
        return this.data.getSeverityLevel() == null ? null : SeverityLevel.values()[this.data.getSeverityLevel().getValue()];
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        Sanitizer.sanitizeMeasurements(this.getMetrics());
    }

    @Override
    protected ExceptionData getData() {
        return this.data;
    }

    protected List<ExceptionDetails> getExceptions() {
        return this.data.getExceptions();
    }

    private void updateException(Throwable throwable, int stackSize) {
        ArrayList<ExceptionDetails> exceptions = new ArrayList<ExceptionDetails>();
        ExceptionTelemetry.convertExceptionTree(throwable, null, exceptions, stackSize);
        this.data.setExceptions(exceptions);
    }

    private static void convertExceptionTree(Throwable exception, ExceptionDetails parentExceptionDetails, List<ExceptionDetails> exceptions, int stackSize) {
        if (exception == null) {
            exception = new Exception("");
        }
        if (stackSize == 0) {
            return;
        }
        ExceptionDetails exceptionDetails = ExceptionTelemetry.createWithStackInfo(exception, parentExceptionDetails);
        exceptions.add(exceptionDetails);
        if (exception.getCause() != null) {
            ExceptionTelemetry.convertExceptionTree(exception.getCause(), exceptionDetails, exceptions, stackSize - 1);
        }
    }

    private static ExceptionDetails createWithStackInfo(Throwable exception, ExceptionDetails parentExceptionDetails) {
        StackTraceElement[] trace;
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        ExceptionDetails exceptionDetails = new ExceptionDetails();
        exceptionDetails.setId(exception.hashCode());
        exceptionDetails.setTypeName(exception.getClass().getName());
        String exceptionMessage = exception.getMessage();
        if (Strings.isNullOrEmpty(exceptionMessage)) {
            exceptionMessage = exception.getClass().getName();
        }
        exceptionDetails.setMessage(exceptionMessage);
        if (parentExceptionDetails != null) {
            exceptionDetails.setOuterId(parentExceptionDetails.getId());
        }
        if ((trace = exception.getStackTrace()) != null && trace.length > 0) {
            List<StackFrame> stack = exceptionDetails.getParsedStack();
            for (int idx = 0; idx < trace.length; ++idx) {
                StackTraceElement elem = trace[idx];
                if (elem.isNativeMethod()) continue;
                String className = elem.getClassName();
                StackFrame frame = new StackFrame();
                frame.setLevel(idx);
                frame.setFileName(elem.getFileName());
                frame.setLine(elem.getLineNumber());
                if (!Strings.isNullOrEmpty(className)) {
                    frame.setMethod(elem.getClassName() + "." + elem.getMethodName());
                } else {
                    frame.setMethod(elem.getMethodName());
                }
                stack.add(frame);
            }
            exceptionDetails.setHasFullStack(true);
        }
        return exceptionDetails;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

