/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertyHelper {
    public static final String SDK_VERSION_FILE_NAME = "sdk-version.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String name) throws IOException {
        Properties props = new Properties();
        ClassLoader classLoader = PropertyHelper.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(name);
        if (inputStream != null) {
            try {
                props.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return props;
    }

    public static Properties getSdkVersionProperties() {
        try {
            return PropertyHelper.getProperties(SDK_VERSION_FILE_NAME);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Could not find sdk version file '%s'", SDK_VERSION_FILE_NAME);
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    private PropertyHelper() {
    }
}

