/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.shutdown;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ChannelFetcher;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public enum SDKShutdownActivity {
    INSTANCE;

    private static volatile SDKShutdownThread shutdownThread;

    public void register(ChannelFetcher fetcher) {
        this.getShutdownThread().register(fetcher);
    }

    public void register(Stoppable stoppable) {
        this.getShutdownThread().register(stoppable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDKShutdownThread getShutdownThread() {
        if (shutdownThread == null) {
            SDKShutdownActivity sDKShutdownActivity = this;
            synchronized (sDKShutdownActivity) {
                if (shutdownThread == null) {
                    try {
                        shutdownThread = new SDKShutdownThread();
                        Runtime.getRuntime().addShutdownHook(shutdownThread);
                    }
                    catch (Exception e) {
                        InternalLogger.INSTANCE.error("Error while adding shutdown hook in getShutDownThread call", new Object[0]);
                        InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
                    }
                }
            }
        }
        return shutdownThread;
    }

    private static class SDKShutdownThread
    extends Thread {
        private boolean stopped = false;
        private final ArrayList<ChannelFetcher> fetchers = new ArrayList();
        private final ArrayList<Stoppable> stoppables = new ArrayList();

        public synchronized void register(ChannelFetcher fetcher) {
            this.fetchers.add(fetcher);
        }

        public synchronized void register(Stoppable stoppable) {
            this.stoppables.add(stoppable);
        }

        @Override
        public synchronized void run() {
            if (this.stopped) {
                return;
            }
            try {
                this.stopChannels();
                this.stopStoppables();
            }
            finally {
                this.stopInternalLogger();
            }
            this.stopped = true;
        }

        private void stopInternalLogger() {
            try {
                InternalLogger.INSTANCE.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void stopChannels() {
            for (ChannelFetcher fetcher : this.fetchers) {
                try {
                    TelemetryChannel channelToStop = fetcher.fetch();
                    if (channelToStop == null) continue;
                    channelToStop.stop(1L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    InternalLogger.INSTANCE.error("Failed to stop channel: '%s'", t.getMessage());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                }
            }
        }

        private void stopStoppables() {
            for (Stoppable stoppable : this.stoppables) {
                try {
                    stoppable.stop(1L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    InternalLogger.INSTANCE.error("Failed to stop stoppable class '%s': '%s'", stoppable.getClass().getName(), t.getMessage());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                }
            }
        }
    }
}

