/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.internal.schemav2.Base;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Envelope
implements JsonSerializable {
    private int ver = 1;
    private String name;
    private String time;
    private double sampleRate = 100.0;
    private String seq;
    private String iKey;
    private ConcurrentMap<String, String> tags;
    private Base data;

    public Envelope() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public void setVer(int value) {
        this.ver = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String value) {
        this.time = value;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double value) {
        this.sampleRate = value;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String value) {
        this.seq = value;
    }

    public String getIKey() {
        return this.iKey;
    }

    public void setIKey(String value) {
        this.iKey = value;
    }

    public ConcurrentMap<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(ConcurrentMap<String, String> value) {
        this.tags = value;
    }

    public Base getData() {
        return this.data;
    }

    public void setData(Base value) {
        this.data = value;
    }

    @Override
    public void serialize(JsonTelemetryDataSerializer writer) throws IOException {
        Preconditions.checkNotNull(writer, "writer must be a non-null value");
        this.serializeContent(writer);
    }

    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        writer.write("ver", this.ver);
        writer.writeRequired("name", this.name, 1024);
        writer.writeRequired("time", this.time, 64);
        if (this.sampleRate > 0.0) {
            writer.write("sampleRate", this.sampleRate);
        }
        writer.write("seq", this.seq, 64);
        writer.write("iKey", this.iKey, 40);
        writer.write("tags", this.tags);
        writer.write("data", this.data);
    }

    protected void InitializeFields() {
    }
}

