/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.EventTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BuiltInProcessor(value="TelemetryEventFilter")
public final class TelemetryEventFilter
implements TelemetryProcessor {
    private final Set<String> notNeededNames = new HashSet<String>();

    @Override
    public boolean process(Telemetry telemetry) {
        if (telemetry == null) {
            return true;
        }
        if (!(telemetry instanceof EventTelemetry)) {
            return true;
        }
        EventTelemetry et = (EventTelemetry)telemetry;
        String eventName = et.getName();
        if (LocalStringsUtils.isNullOrEmpty(eventName)) {
            return true;
        }
        return !this.notNeededNames.contains(eventName);
    }

    public void setNotNeededNames(String notNeededNames) throws Throwable {
        try {
            List<String> notNeededAsList = Arrays.asList(notNeededNames.split(","));
            for (String notNeeded : notNeededAsList) {
                String ready = notNeeded.trim();
                if (LocalStringsUtils.isNullOrEmpty(ready)) continue;
                this.notNeededNames.add(ready);
            }
            InternalLogger.INSTANCE.trace(String.format("TelemetryEventFilter: set NotNeededNames: %s", notNeededNames), new Object[0]);
        }
        catch (Throwable e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, String.format("TelemetryEventFilter: failed to parse NotNeededNames: %s", notNeededNames), new Object[0]);
            throw e;
        }
    }
}

