/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.CpuPerformanceCounterCalculator;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;

final class ProcessCpuPerformanceCounter
extends AbstractPerformanceCounter {
    private CpuPerformanceCounterCalculator cpuPerformanceCounterCalculator;

    public ProcessCpuPerformanceCounter() {
        try {
            this.cpuPerformanceCounterCalculator = new CpuPerformanceCounterCalculator();
        }
        catch (Throwable t) {
            this.cpuPerformanceCounterCalculator = null;
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create ProcessCpuPerformanceCounter: %s", t.getMessage());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            throw new RuntimeException("Failed to create ProcessCpuPerformanceCounter");
        }
    }

    @Override
    public String getId() {
        return "JSDK_ProcessCpuPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        if (this.cpuPerformanceCounterCalculator == null) {
            return;
        }
        double processCpuUsage = this.cpuPerformanceCounterCalculator.getProcessCpuUsage();
        InternalLogger.INSTANCE.trace("Performance Counter: %s %s: %s", ProcessCpuPerformanceCounter.getProcessCategoryName(), "% Processor Time", processCpuUsage);
        PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry(ProcessCpuPerformanceCounter.getProcessCategoryName(), "% Processor Time", SystemInformation.INSTANCE.getProcessId(), processCpuUsage);
        telemetryClient.track(telemetry);
    }
}

