/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.microsoft.applicationinsights.internal.common.LogTelemetryClientProxy;
import com.microsoft.applicationinsights.internal.common.TelemetryClientProxy;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.logback.internal.ApplicationInsightsLogEvent;

public class ApplicationInsightsAppender
extends AppenderBase<ILoggingEvent> {
    private boolean isInitialized = false;
    private LogTelemetryClientProxy logTelemetryClientProxy;
    private String instrumentationKey;

    public TelemetryClientProxy getTelemetryClientProxy() {
        return this.logTelemetryClientProxy;
    }

    public void setInstrumentationKey(String instrumentationKey) {
        this.instrumentationKey = instrumentationKey;
    }

    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted() || !this.isInitialized) {
            return;
        }
        ApplicationInsightsLogEvent aiEvent = new ApplicationInsightsLogEvent(eventObject);
        this.logTelemetryClientProxy.sendEvent(aiEvent);
    }

    public void start() {
        super.start();
        try {
            this.logTelemetryClientProxy = new LogTelemetryClientProxy(this.instrumentationKey);
            this.isInitialized = true;
        }
        catch (Exception e) {
            this.isInitialized = false;
            InternalLogger.INSTANCE.error("Failed to initialize appender with exception: %s.", new Object[]{e.toString()});
        }
    }
}

