/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import java.util.Objects;

public final class SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    AttributeKey<String> dbTableAttribute = DbIncubatingAttributes.DB_SQL_TABLE;
    boolean statementSanitizationEnabled = true;

    SqlClientAttributesExtractorBuilder(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setTableAttribute(AttributeKey<String> dbTableAttribute) {
        this.dbTableAttribute = Objects.requireNonNull(dbTableAttribute);
        return this;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new SqlClientAttributesExtractor(this.getter, this.dbTableAttribute, SqlStatementSanitizer.create(this.statementSanitizationEnabled));
    }
}

