/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.contrib.json;

import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.contrib.json.JsonFormatter;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.core.CoreConstants;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.core.LayoutBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public abstract class JsonLayoutBase<E>
extends LayoutBase<E> {
    public static final String CONTENT_TYPE = "application/json";
    protected boolean includeTimestamp = true;
    protected String timestampFormat;
    protected String timestampFormatTimezoneId;
    protected boolean appendLineSeparator = false;
    protected JsonFormatter jsonFormatter;

    @Override
    public String doLayout(E e) {
        Map map = this.toJsonMap(e);
        if (map == null || map.isEmpty()) {
            return null;
        }
        String string = this.getStringFromFormatter(map);
        return this.isAppendLineSeparator() ? string + CoreConstants.LINE_SEPARATOR : string;
    }

    private String getStringFromFormatter(Map map) {
        JsonFormatter jsonFormatter = this.getJsonFormatter();
        if (jsonFormatter == null) {
            this.addError("JsonFormatter has not been configured on JsonLayout instance " + this.getClass().getName() + ".  Defaulting to map.toString().");
            return map.toString();
        }
        try {
            return jsonFormatter.toJsonString(map);
        }
        catch (Exception exception) {
            this.addError("JsonFormatter failed.  Defaulting to map.toString().  Message: " + exception.getMessage(), exception);
            return map.toString();
        }
    }

    protected String formatTimestamp(long l) {
        if (this.timestampFormat == null || l < 0L) {
            return String.valueOf(l);
        }
        Date date = new Date(l);
        DateFormat dateFormat = this.createDateFormat(this.timestampFormat);
        if (this.timestampFormatTimezoneId != null) {
            TimeZone timeZone = TimeZone.getTimeZone(this.timestampFormatTimezoneId);
            dateFormat.setTimeZone(timeZone);
        }
        return this.format(date, dateFormat);
    }

    public void addMap(String string, boolean bl, Map<String, ?> map, Map<String, Object> map2) {
        if (bl && map != null && !map.isEmpty()) {
            map2.put(string, map);
        }
    }

    public void addTimestamp(String string, boolean bl, long l, Map<String, Object> map) {
        String string2;
        if (bl && (string2 = this.formatTimestamp(l)) != null) {
            map.put(string, string2);
        }
    }

    public void add(String string, boolean bl, String string2, Map<String, Object> map) {
        if (bl && string2 != null) {
            map.put(string, string2);
        }
    }

    protected DateFormat createDateFormat(String string) {
        return new SimpleDateFormat(string);
    }

    protected String format(Date date, DateFormat dateFormat) {
        return dateFormat.format(date);
    }

    protected abstract Map toJsonMap(E var1);

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean bl) {
        this.includeTimestamp = bl;
    }

    public JsonFormatter getJsonFormatter() {
        return this.jsonFormatter;
    }

    public void setJsonFormatter(JsonFormatter jsonFormatter) {
        this.jsonFormatter = jsonFormatter;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public String getTimestampFormatTimezoneId() {
        return this.timestampFormatTimezoneId;
    }

    public void setTimestampFormatTimezoneId(String string) {
        this.timestampFormatTimezoneId = string;
    }

    public boolean isAppendLineSeparator() {
        return this.appendLineSeparator;
    }

    public void setAppendLineSeparator(boolean bl) {
        this.appendLineSeparator = bl;
    }
}

