/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.jul;

import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.Level;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.Logger;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;

public class JULHelper {
    public static final boolean isRegularNonRootLogger(PatchLogger julLogger) {
        if (julLogger == null) {
            return false;
        }
        return !julLogger.getName().equals("");
    }

    public static final boolean isRoot(PatchLogger julLogger) {
        if (julLogger == null) {
            return false;
        }
        return julLogger.getName().equals("");
    }

    public static java.util.logging.Level asJULLevel(Level lbLevel) {
        if (lbLevel == null) {
            throw new IllegalArgumentException("Unexpected level [null]");
        }
        switch (lbLevel.levelInt) {
            case -2147483648: {
                return java.util.logging.Level.ALL;
            }
            case 5000: {
                return java.util.logging.Level.FINEST;
            }
            case 10000: {
                return java.util.logging.Level.FINE;
            }
            case 20000: {
                return java.util.logging.Level.INFO;
            }
            case 30000: {
                return java.util.logging.Level.WARNING;
            }
            case 40000: {
                return java.util.logging.Level.SEVERE;
            }
            case 0x7FFFFFFF: {
                return java.util.logging.Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unexpected level [" + lbLevel + "]");
    }

    public static String asJULLoggerName(String loggerName) {
        if ("ROOT".equals(loggerName)) {
            return "";
        }
        return loggerName;
    }

    public static PatchLogger asJULLogger(String loggerName) {
        String julLoggerName = JULHelper.asJULLoggerName(loggerName);
        return PatchLogger.getLogger(julLoggerName);
    }

    public static PatchLogger asJULLogger(Logger logger) {
        return JULHelper.asJULLogger(logger.getName());
    }
}

