/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.db;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.AutoSqlSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.StatementSanitizationConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;

public final class SqlStatementSanitizer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private static final Cache<String, SqlStatementInfo> sqlToStatementInfoCache = Cache.builder().setMaximumSize(1000L).build();

    public static SqlStatementInfo sanitize(@Nullable String statement) {
        if (!StatementSanitizationConfig.isStatementSanitizationEnabled() || statement == null) {
            return SqlStatementInfo.create(statement, null, null);
        }
        return sqlToStatementInfoCache.computeIfAbsent(statement, k -> {
            supportability.incrementCounter("SqlStatementSanitizer cache miss");
            return AutoSqlSanitizer.sanitize(statement);
        });
    }

    private SqlStatementSanitizer() {
    }
}

