/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigParsingException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

final class ConfigValueParsers {
    static boolean parseBoolean(String propertyName, String value) {
        return Boolean.parseBoolean(value);
    }

    static int parseInt(String propertyName, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw ConfigValueParsers.newInvalidPropertyException(propertyName, value, "integer");
        }
    }

    static long parseLong(String propertyName, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw ConfigValueParsers.newInvalidPropertyException(propertyName, value, "long");
        }
    }

    static double parseDouble(String propertyName, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw ConfigValueParsers.newInvalidPropertyException(propertyName, value, "double");
        }
    }

    private static ConfigParsingException newInvalidPropertyException(String name, String value, String type) {
        throw new ConfigParsingException("Invalid value for property " + name + "=" + value + ". Must be a " + type + ".");
    }

    static List<String> parseList(String propertyName, String value) {
        return Collections.unmodifiableList(ConfigValueParsers.filterBlanks(value.split(",")));
    }

    static Map<String, String> parseMap(String propertyName, String value) {
        return ConfigValueParsers.parseList(propertyName, value).stream().map(keyValuePair -> ConfigValueParsers.trim(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2 || ((String)splitKeyValuePairs.get(0)).isEmpty()) {
                throw new ConfigParsingException("Invalid map property: " + propertyName + "=" + value);
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    private static List<String> filterBlanks(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static List<String> trim(String[] values) {
        return Arrays.stream(values).map(String::trim).collect(Collectors.toList());
    }

    static Duration parseDuration(String propertyName, String value) {
        String unitString = ConfigValueParsers.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        try {
            long rawNumber = Long.parseLong(numberString.trim());
            TimeUnit unit = ConfigValueParsers.getDurationUnit(unitString.trim());
            return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
        }
        catch (NumberFormatException e) {
            throw new ConfigParsingException("Invalid duration property " + propertyName + "=" + value + ". Expected number, found: " + numberString);
        }
        catch (ConfigParsingException ex) {
            throw new ConfigParsingException("Invalid duration property " + propertyName + "=" + value + ". " + ex.getMessage());
        }
    }

    private static TimeUnit getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new ConfigParsingException("Invalid duration string, found: " + unitString);
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }

    private ConfigValueParsers() {
    }
}

